/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.helper.DataFoundationWSHelper;
import com.konylabs.middleware.appservices.custom.processors.util.ObjectServicePreProcessorUtil;
import com.konylabs.middleware.controller.impl.DataControllerRequestJSONImpl;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.AbstractRowProcessingStratergy;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.MiddlewarePayloadParsingUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PassthroughPayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(PassthroughPayloadParser.class);

    public PassthroughPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse) {
        super(httpServletRequest, context, httpServletResponse);
    }

    @Override
    public RequestData parse() throws MiddlewareException, Exception {
        LOGGER.debug((Object)" Inside parse()");
        ObjectServiceRequestData objectServiceRequestData = new ObjectServiceRequestData(this.context.getAppMetadata());
        Map queryMap = MiddlewarePayloadParsingUtil.parseQueryParams((String)this.httpServletRequest.getQueryString());
        InputPayloadMetadata payloadMetadata = new InputPayloadMetadata();
        DataControllerRequestJSONImpl dcr = new DataControllerRequestJSONImpl(null, this.httpServletRequest);
        dcr.setAttribute("passThruHttpEntity", ObjectServicePreProcessorUtil.getInputStreamFromCustomProcessor(this.httpServletRequest, this.context));
        dcr.addRequestParam_("objectID", this.context.getObjectId());
        dcr.addRequestParam_("appID", this.context.getAppId());
        dcr.addRequestParam_("serviceID", this.context.getServiceId());
        String operationId = this.context.getDefaultOperation();
        dcr.addRequestParam_("operationId", operationId);
        dcr.setAttribute("queryparams", queryMap);
        dcr.addRequestParam_("channel", "rc");
        dcr.setAttribute("tenantBean", this.context.getTenantBean());
        dcr.setAttribute("appregistry_Cache", this.context.getAppMetadata().getAppCache());
        dcr.setAttribute("gatewaywrapperobject", this.context.getGateWayWrapper());
        dcr.setAttribute("metricsBean", this.httpServletRequest.getAttribute("metricsBean"));
        dcr.getHeaderMap().put("X-Kony-API-Version", this.context.getAppVersion().getVersion());
        DataFoundationWSHelper.setMapperCallbackHandler(new AbstractRowProcessingStratergy(), this.context.getAppMetadata().getObjectMetadata(this.context.getObjectId()), dcr);
        payloadMetadata.setDCR(dcr);
        objectServiceRequestData.setHttpServletRequest(this.httpServletRequest);
        objectServiceRequestData.setHttpServletResponse(this.httpServletResponse);
        objectServiceRequestData.setInputPayloadMetadata(payloadMetadata);
        return objectServiceRequestData;
    }
}

