/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.utilities.ResponseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PassthroughProcessingAsyncHandler
implements AsyncHandler,
AppServicesAsyncHandlerChain {
    private static final Logger LOGGER = Logger.getLogger(PassthroughProcessingAsyncHandler.class);

    PassthroughProcessingAsyncHandler() {
    }

    @Override
    public void onSuccess(DataControllerRequest request, DataControllerResponse dcResponse, Context context) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)context.get("httpServletRequest");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<ObjectServiceResponseData> parentHandler = this.getParentHandler(parentContext);
        ObjectServiceResponseData objectServiceResponseData = (ObjectServiceResponseData)context.get("objectServiceResponseData");
        ResponseUtils.addResponseHeadersToServletResponse((HttpServletResponse)response, (DataControllerResponse)dcResponse);
        Object result = dcResponse.getAttribute("chunkedresults_json");
        if (dcResponse.getHeaders() != null && StringUtils.isNotBlank((String)((String)dcResponse.getHeaders().get("Content-Range")))) {
            response.setStatus(206);
        }
        objectServiceResponseData.setResponseStream(result);
        parentHandler.onSuccess(httpServletRequest, response, objectServiceResponseData, parentContext);
    }

    @Override
    public void onError(DataControllerRequest request, DataControllerResponse dcResponse, MiddlewareException exception, Context context) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)context.get("httpServletRequest");
        HttpServletResponse response = (HttpServletResponse)context.get("response");
        Context parentContext = (Context)context.get("parentContext");
        LOGGER.error((Object)"caught error ", (Throwable)exception);
        ResponseUtils.updatePassThroughErrorResponse((HttpServletResponse)response, (Exception)((Object)exception));
        this.getParentHandler(parentContext).onError(httpServletRequest, response, (Exception)((Object)exception), parentContext);
    }

    public AppServicesAsyncHandler<ObjectServiceResponseData> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }
}

