/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.commons.xss.XSSValidator;
import com.konylabs.middleware.api.processor.QueryParamsHandler;
import com.konylabs.middleware.api.processor.impl.InputData;
import com.konylabs.middleware.api.processor.impl.RequestPayloadHandlerImpl;
import com.konylabs.middleware.api.processor.manager.FabricRequestManager;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.datasourcelogs.DeviceRequestData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.objservices.runtime.ResponseDeltaContextDTO;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.builder.BulkUploadPayloadParser;
import com.konylabs.middleware.request.builder.DownloadPayloadParser;
import com.konylabs.middleware.request.builder.PayloadParser;
import com.konylabs.middleware.request.builder.RequestBuilder;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.SingleRecordPayloadParser;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MetricsBeanUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class PayloadParserUtil {
    private static final Logger LOGGER = Logger.getLogger(PayloadParserUtil.class);

    public static JsonObject getJsonDataFromKey(JsonObject inputFieldJson, String key) {
        return inputFieldJson != null && inputFieldJson.has(key) ? inputFieldJson.getAsJsonObject(key) : null;
    }

    public static JsonElement getJsonDataFromKey(HttpServletRequest httpServletRequest, String key) {
        JsonParser jsonParser = new JsonParser();
        if (key != null && httpServletRequest.getParameter(key) != null) {
            String parameter = httpServletRequest.getParameter(key);
            String decode = EncodeUtils.decode((String)parameter);
            return jsonParser.parse(decode);
        }
        return null;
    }

    public static String getStringFromKey(HttpServletRequest httpServletRequest, String key) {
        if (key != null && httpServletRequest.getParameter(key) != null) {
            return EncodeUtils.decode((String)httpServletRequest.getParameter(key));
        }
        return null;
    }

    public static JsonElement extractJson(HttpServletRequest httpServletRequest, Map<String, String> queryParams) {
        long extractPayloadStartTime = System.currentTimeMillis();
        FabricRequestManager requestManager = (FabricRequestManager)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"REQUEST_MANAGER");
        RequestPayloadHandlerImpl payloadHandler = (RequestPayloadHandlerImpl)requestManager.getPayloadHandler();
        InputData inputData = payloadHandler.getInputPayload();
        JsonElement inputPayload = inputData.getPayloadAsJson();
        JsonObject queryParamsJson = inputData.getPayloadUnit("queryparams") != null ? (JsonElement)inputData.getPayloadUnit("queryparams").getValue() : new JsonObject();
        queryParams.putAll(ObjectServiceUtil.convertQueryJsonToMap(queryParamsJson.getAsJsonObject()));
        QueryParamsHandler queryParamsHandler = requestManager.getQueryParamsHandler();
        queryParamsHandler.getParameterNames().stream().forEach(name -> queryParams.put((String)name, queryParamsHandler.getParameter(name)));
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"reqbytes", (Object)(inputPayload != null ? new Gson().toJson(inputPayload).getBytes().length : 0));
        if (inputPayload == null) {
            inputPayload = new JsonObject();
        }
        httpServletRequest.setAttribute("konyreportingparams", (Object)queryParams.get("konyreportingparams"));
        MetricsBeanUtils.addParamToMetricsBean((HttpServletRequest)httpServletRequest, (String)"reqprsdur", (Object)(System.currentTimeMillis() - extractPayloadStartTime));
        return inputPayload;
    }

    public static JsonObject getAndRemove(JsonObject inputFieldJson, String key) {
        JsonObject jsonObject = null;
        if (inputFieldJson != null && inputFieldJson.has(key)) {
            jsonObject = inputFieldJson.getAsJsonObject(key);
            inputFieldJson.remove(key);
        }
        return jsonObject;
    }

    public static PayloadParser getPayloadParser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestContext context) throws IOException {
        JsonObject inputPayload;
        LOGGER.debug((Object)" Inside getPayloadParser()");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        JsonElement totalPayload = PayloadParserUtil.extractJson(httpServletRequest, queryParams);
        context.setRawJson((JsonElement)PayloadParserUtil.clonePayloadForRecording(totalPayload));
        if (totalPayload.isJsonObject() && !(inputPayload = totalPayload.getAsJsonObject()).has("records")) {
            return OperationEnum.get.getOperationName().equals(context.getDefaultOperation()) ? new DownloadPayloadParser(httpServletRequest, context, httpServletResponse, totalPayload, queryParams) : new SingleRecordPayloadParser(httpServletRequest, context, httpServletResponse, totalPayload, queryParams);
        }
        return new BulkUploadPayloadParser(httpServletRequest, context, httpServletResponse, totalPayload, queryParams);
    }

    public static JsonObject clonePayloadForRecording(JsonElement totalPayload) {
        JsonParser parser = new JsonParser();
        return (JsonObject)parser.parse(totalPayload.toString());
    }

    public static JsonElement getPayloadAndSetQueryParamMap(HttpServletRequest request, Map<String, String> queryParamMap) {
        LOGGER.debug((Object)" Inside parse()");
        Map urlParams = request.getParameterMap();
        JsonElement inputPayload = null;
        JsonParser jsonParser = new JsonParser();
        Set keys = urlParams.keySet();
        for (String key : keys) {
            StringBuffer sb = new StringBuffer();
            for (String decodedVal : (String[])urlParams.get(key)) {
                sb.append(decodedVal);
            }
            String value = sb.toString();
            if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
            if ("jsondata".equals(key)) {
                inputPayload = jsonParser.parse(value);
                continue;
            }
            if ("queryparams".equals(key)) {
                JsonObject queryParamJson = jsonParser.parse(value).getAsJsonObject();
                Set entrySet = queryParamJson.entrySet();
                for (Map.Entry entry : entrySet) {
                    queryParamMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                continue;
            }
            queryParamMap.put(key, value);
        }
        return inputPayload;
    }

    public static RequestData getRequestDataByParsingPayload(HttpServletRequest httpServletRequest, HttpServletResponse resp, XSSValidator xssValidator, UriContext uriContext, RequestContext requestContext) throws Exception {
        RequestBuilder builder = uriContext.getBuilder();
        builder.with(httpServletRequest);
        builder.with(resp);
        builder.with(uriContext);
        builder.with(xssValidator);
        builder.with(requestContext);
        RequestData requestData = builder.build();
        httpServletRequest.setAttribute("requestdata", (Object)requestData);
        DiagnosticLogService.saveLogMetaIntoNDC("sessionid", httpServletRequest.getSession().getId());
        DiagnosticLogService.saveLogMetaIntoNDC("appID", requestData.getAppId());
        String headers = MiddlewareUtils.getHeadersAsString(httpServletRequest);
        DeviceRequestData deviceRequestData = (DeviceRequestData)httpServletRequest.getAttribute("DeviceReqLogBean");
        deviceRequestData.setHeaders(headers);
        DiagnosticLogService.logDeviceRequestData(deviceRequestData);
        return requestData;
    }

    public static void getObjectsToBeDownloadedFromGivenIndex(int startIndex, ApplicationMetadata appMetadata, boolean downloadMode, List<String> downloadableObjects) {
        LOGGER.debug((Object)" Inside getObjectsToBeDownloadedFromCurrentObject");
        for (int i = startIndex; i < appMetadata.getObjectNames().size(); ++i) {
            String nextObject = appMetadata.getObjectNames().get(i);
            if (downloadMode != appMetadata.getObjectMetadata(nextObject).isOffline()) continue;
            if (appMetadata.getOperatonMapingByObjectId(nextObject).containsKey(OperationEnum.get.name())) {
                downloadableObjects.add(nextObject);
                continue;
            }
            LOGGER.info((Object)("Get operation is not mapped for object " + nextObject));
        }
    }

    public static void getObjectsToBeDownloaded(ApplicationMetadata appMetadata, ResponseDeltaContextDTO deltaContextObj, boolean downloadMode, List<String> downloadableObjects) {
        int startIndex = 0;
        if (deltaContextObj != null && StringUtils.isNotBlank((String)deltaContextObj.getCurobj()) && appMetadata.getObjectMetadata(deltaContextObj.getCurobj()).isOffline() == downloadMode) {
            downloadableObjects.add(deltaContextObj.getCurobj());
            startIndex = appMetadata.getObjectNames().indexOf(deltaContextObj.getCurobj()) + 1;
        }
        PayloadParserUtil.getObjectsToBeDownloadedFromGivenIndex(startIndex, appMetadata, downloadMode, downloadableObjects);
    }

    public static String getEntryValueBasedOnType(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject() || element.isJsonArray()) {
            return element.toString();
        }
        return element.getAsString();
    }

    public static boolean isStreamAvailable(PushbackInputStream pushbackInputStream) {
        try {
            int read = pushbackInputStream.read();
            if (read != -1) {
                pushbackInputStream.unread(read);
                return Boolean.TRUE;
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return Boolean.FALSE;
    }

    private PayloadParserUtil() {
    }
}

