/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.mbaas.MBAASLogicalUrlEnum;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.tenant.TenantBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RequestContext {
    private String serviceId;
    private String requestedAppVersion;
    private String objectId;
    private String operationId;
    private String requestedmethod;
    private String requestOverrideMethod;
    private String appId;
    private String apiVersion;
    private String authHeader;
    private String securityLevel;
    private String requestedUrl;
    private String requestId;
    private String resourceName;
    private String requestType;
    private boolean bulkRequest;
    private boolean requestPassThrough;
    private boolean responsePassThrough;
    private boolean objectLevelCall = false;
    private MBAASLogicalUrlEnum logicalUrl;
    private AppCache appCache;
    private TenantBean<AppCache> tenantBean;
    private JsonElement rawJson;
    private MBAASGateWayWrapper gateWayWrapper;
    private boolean requestCacheSupported;
    private String serviceCategory;
    private CacheDirector cacheDirector;
    private final Map<String, String> serviceInfoForTimerData = new HashMap<String, String>();

    public boolean isGatewayEnabled() {
        return EnvironmentFactory.getEnvironment().isGatewayEnabled();
    }

    public String getSecurityLevel() {
        return this.securityLevel;
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public String getRequestedUrl() {
        return this.requestedUrl;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceUrl() {
        return this.logicalUrl.getResourcePath() + this.getAppId();
    }

    public void setLogicalUrl(MBAASLogicalUrlEnum logicalUrl) {
        this.logicalUrl = logicalUrl;
    }

    public MBAASGateWayWrapper getGateWayWrapper() {
        return this.gateWayWrapper;
    }

    void setGateWayWrapper(MBAASGateWayWrapper gateWayWrapper) {
        this.gateWayWrapper = gateWayWrapper;
    }

    public void setSecurityLevel(String securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void setAuthHeader(String authHeader) {
        this.authHeader = authHeader;
    }

    public void setRequestedUrl(String requestedUrl) {
        this.requestedUrl = requestedUrl;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getServiceId() {
        if (StringUtils.isNotBlank((String)this.serviceId)) {
            return this.serviceId;
        }
        if (this.getAppMetadata() != null && this.getAppMetadata().getOperatonMapingByObjectId(this.objectId) != null && this.getAppMetadata().getOperatonMapingByObjectId(this.objectId).get(this.operationId) != null) {
            return this.getAppMetadata().getOperatonMapingByObjectId(this.objectId).get(this.operationId).getServiceid();
        }
        return this.serviceIdForObjectServiceLevelCall();
    }

    public AppVersion getAppVersion() {
        return new AppVersion(this.appId, this.apiVersion);
    }

    public String getRequestedAppVersion() {
        return this.requestedAppVersion;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getDefaultOperation() {
        return this.operationId;
    }

    public String getRequestedMethod() {
        return this.requestedmethod;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    void setRequestedAppVersion(String requestedAppVersion) {
        this.requestedAppVersion = requestedAppVersion;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setDefaultOperation(String operationId) {
        this.operationId = operationId;
    }

    public void setRequestedMethod(String requestedmethod) {
        this.requestedmethod = requestedmethod;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    void setBulkRequest(boolean bulkRequest) {
        this.bulkRequest = bulkRequest;
    }

    public boolean isBulkRequest() {
        return this.bulkRequest;
    }

    public boolean isRequestpassthrough() {
        return this.requestPassThrough;
    }

    public void setRequestPassThrough(boolean requestPassThrough) {
        this.requestPassThrough = requestPassThrough;
    }

    public void setResponsePassThrough(boolean responsePassThrough) {
        this.responsePassThrough = responsePassThrough;
    }

    public boolean isResponsePassThrough() {
        return this.responsePassThrough;
    }

    public boolean isObjectLevelCall() {
        return this.objectLevelCall;
    }

    public void setObjectLevelCall(boolean objectCall) {
        this.objectLevelCall = objectCall;
    }

    public AppCache getAppCache() {
        return this.appCache;
    }

    public void setAppCache(AppCache appCache) {
        this.appCache = appCache;
    }

    public ApplicationMetadata getAppMetadata() {
        return (ApplicationMetadata)this.appCache.getAppMetadata(this.getAppVersion());
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public JsonElement getRawJson() {
        return this.rawJson;
    }

    public void setRawJson(JsonElement rawJson) {
        this.rawJson = rawJson;
    }

    public TenantBean<AppCache> getTenantBean() {
        return this.tenantBean;
    }

    public void setTenantBean(TenantBean<AppCache> tenantBean) {
        this.tenantBean = tenantBean;
    }

    public boolean isRequestCacheSupported() {
        return this.requestCacheSupported;
    }

    public void setRequestCacheSupported(boolean requestCacheSupported) {
        this.requestCacheSupported = requestCacheSupported;
    }

    public String getServiceCategory() {
        return this.serviceCategory;
    }

    public void setServiceCategory(String serviceCategory) {
        this.serviceCategory = serviceCategory;
    }

    public CacheDirector getCacheDirector() {
        return this.cacheDirector;
    }

    public void setCacheDirector(CacheDirector cacheDirector) {
        this.cacheDirector = cacheDirector;
    }

    public String getRequestOverrideMethod() {
        return this.requestOverrideMethod;
    }

    public void setRequestOverrideMethod(String requestOverrideMethod) {
        this.requestOverrideMethod = requestOverrideMethod;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getServiceInfoForTimerData() {
        if (this.serviceInfoForTimerData.isEmpty()) {
            this.prepareServiceInfoForTimerData();
        }
        this.addFieldsInDiagnosticContext();
        return this.serviceInfoForTimerData;
    }

    private void prepareServiceInfoForTimerData() {
        this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_NAME.getName(), this.getDefaultIfNull(this.getAppId()));
        this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_VERSION.getName(), this.getDefaultIfNull(this.getApiVersion()));
        String operationName = StringUtils.isNotBlank((String)this.objectId) ? this.objectId : this.getServiceId();
        this.serviceInfoForTimerData.put(MonitoringProperties.OPERATION_NAME.getName(), this.getDefaultIfNull(operationName));
        this.serviceInfoForTimerData.put(MonitoringProperties.VERB.getName(), this.getDefaultIfNull(this.getRequestedMethod()));
        if ("getMetadata".equalsIgnoreCase(this.getServiceId())) {
            this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_TYPE.getName(), "getMetadata");
        } else if (this.getAppMetadata() != null && this.getAppMetadata().getServiceMetadata(this.getServiceId()) != null) {
            this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_TYPE.getName(), this.getDefaultIfNull(this.getAppMetadata().getServiceMetadata(this.getServiceId()).getService().getServiceType()));
        } else {
            this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_TYPE.getName(), "unknown");
        }
        if (MonitoringUtils.isOrchestrationService(this.serviceInfoForTimerData.get(MonitoringProperties.SERVICE_TYPE.getName()))) {
            this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_CATEGORY.getName(), "Orchestration");
        } else {
            this.serviceInfoForTimerData.put(MonitoringProperties.SERVICE_CATEGORY.getName(), this.getDefaultIfNull(this.getServiceCategory()));
        }
    }

    private void addFieldsInDiagnosticContext() {
        String serviceNameToLog = StringUtils.equals((String)"1.0", (String)this.apiVersion) ? this.appId : String.format("%s/%s", this.appId, this.apiVersion);
        String opName = this.serviceInfoForTimerData.get(MonitoringProperties.OPERATION_NAME.getName());
        DiagnosticContext.addCustomFields((String)"svc", (String)serviceNameToLog);
        DiagnosticContext.addCustomFields((String)"op", (String)opName);
    }

    private String serviceIdForObjectServiceLevelCall() {
        return StringUtils.isNotBlank((String)this.requestType) ? this.appId + "-" + this.requestType : "getMetadata";
    }

    private String getDefaultIfNull(String value) {
        return StringUtils.defaultIfBlank((String)value, (String)"unknown");
    }
}

