/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kony.mapper.model.AbstractNode;
import com.kony.mapper.model.NodeElement;
import com.kony.mapper.model.NodeList;
import com.kony.mapper.model.NodePrimitive;
import com.konylabs.middleware.appservices.common.util.OfflineUtil;
import com.konylabs.middleware.objservices.runtime.metadata.FieldMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.request.builder.OperationStrategy;
import com.konylabs.middleware.request.builder.RowElement;
import com.konylabs.middleware.request.builder.RowList;
import com.konylabs.middleware.request.builder.RowMetadata;
import com.konylabs.middleware.request.builder.RowPrimitive;
import com.konylabs.middleware.request.builder.RowProcessingStrategy;
import com.konylabs.middleware.request.builder.RowUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Row
extends AbstractNode
implements RowElement<RowMetadata> {
    private static final Logger LOGGER = Logger.getLogger(AbstractNode.class);
    private JsonObject inputJson;
    private RowMetadata metadata;
    private OperationStrategy strategy;

    public Row(JsonObject jsonObject) {
        this.inputJson = jsonObject;
    }

    public RowElement<?> getValue(String key) {
        LOGGER.debug((Object)" Inside getValue()");
        JsonElement jsonElement = this.inputJson.get(key);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        Object rowElementMetadata = RowUtil.getRowElementMetadata(this.metadata.getObjectMetadata(), key);
        if (jsonElement.isJsonObject()) {
            Row row = new Row(jsonElement.getAsJsonObject());
            row.setMetadata(new RowMetadata(this.metadata.getObjectMetadata(), key));
            return row;
        }
        if (jsonElement.isJsonArray()) {
            RowList rowList = new RowList(jsonElement.getAsJsonArray());
            rowList.setMetadata(new RowMetadata((ObjectMetadata)rowElementMetadata, key));
            return rowList;
        }
        RowPrimitive rowPrimitive = new RowPrimitive(jsonElement.getAsJsonPrimitive());
        rowPrimitive.setMetadata((FieldMetadata)rowElementMetadata);
        return rowPrimitive;
    }

    public void setValue(String key, NodeElement value) {
        RowProcessingStrategy rowSummaryStratergy = this.metadata.getRowSummaryStrategy();
        if (value instanceof NodeList) {
            rowSummaryStratergy.beforeAddingRowListToRow(this, (RowList)value);
            this.inputJson.add(key, ((RowList)value).getJsonElement());
        } else if (value instanceof NodePrimitive) {
            FieldMetadata rowPrimitiveMetadata;
            rowSummaryStratergy.beforeAddingRowPrimitiveToRow(key, this, (NodePrimitive)value);
            FieldMetadata fieldMetadata = rowPrimitiveMetadata = this.metadata.getObjectMetadata() != null ? this.metadata.getObjectMetadata().getFieldMetadataMap().get(key) : null;
            if (rowPrimitiveMetadata != null) {
                this.getMetadata().incrementNumberOfColumnsInResponse();
                OfflineUtil.addTypedValueToJson(key, ((NodePrimitive)value).getValue(), rowPrimitiveMetadata.getDatatype(), this.inputJson);
            } else {
                this.inputJson.addProperty(key, ((NodePrimitive)value).getValue().toString());
            }
        } else {
            JsonElement inputValue = ((Row)value).getJsonElement();
            this.inputJson.add(key, inputValue);
        }
    }

    public void setValue(String key, JsonElement value) {
        this.inputJson.add(key, value);
    }

    public void setValue(String key, String value) {
        this.inputJson.addProperty(key, value);
    }

    public void setValue(String key, Long value) {
        this.inputJson.addProperty(key, (Number)value);
    }

    public void remove(String key) {
    }

    public Set<String> getKeys() {
        LOGGER.debug((Object)" Inside getKeys()");
        HashSet<String> paramNames = new HashSet<String>();
        Set entries = this.inputJson.entrySet();
        for (Map.Entry entry : entries) {
            paramNames.add((String)entry.getKey());
        }
        return paramNames;
    }

    @Override
    public RowMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.inputJson.getAsString();
    }

    @Override
    public JsonElement getJsonElement() {
        return this.inputJson;
    }

    public void setMetadata(RowMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public OperationStrategy getStrategy() {
        return this.strategy;
    }

    void setStrategy(OperationStrategy strategy) {
        this.strategy = strategy;
    }
}

