/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kony.mapper.model.AbstractNodeList;
import com.kony.mapper.model.NodeElement;
import com.konylabs.middleware.request.builder.OperationStrategy;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowElement;
import com.konylabs.middleware.request.builder.RowMetadata;
import java.util.Iterator;

public class RowList
extends AbstractNodeList
implements RowElement<RowMetadata> {
    private final JsonArray jsonArray;
    private RowMetadata metadata;

    public RowList(JsonArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public Iterable<NodeElement> getNodeElements() {
        return new Iterable<NodeElement>(){

            @Override
            public Iterator<NodeElement> iterator() {
                final Iterator jsonElementIterator = RowList.this.jsonArray.iterator();
                return new Iterator<NodeElement>(){

                    @Override
                    public boolean hasNext() {
                        return jsonElementIterator.hasNext();
                    }

                    @Override
                    public NodeElement next() {
                        JsonElement jsonElement = (JsonElement)jsonElementIterator.next();
                        if (jsonElement != null && jsonElement.isJsonObject()) {
                            Row row = new Row((JsonObject)jsonElement);
                            row.setMetadata(RowList.this.metadata);
                            return row;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        jsonElementIterator.remove();
                    }
                };
            }
        };
    }

    public void addNodeElement(NodeElement node) {
        if (node != null) {
            ((Row)node).getMetadata().getRowSummaryStrategy().beforeAddingRowToRowList((Row)node, this);
            this.jsonArray.add(((Row)node).getJsonElement());
        }
    }

    @Override
    public RowMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public JsonElement getJsonElement() {
        return this.jsonArray;
    }

    public void setMetadata(RowMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public OperationStrategy getStrategy() {
        return null;
    }
}

