/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.request.builder.RowProcessingStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RowMetadata {
    private String operationId;
    private String objectName;
    private ObjectMetadata objectMetadata;
    private StringBuilder checkSum;
    private PrimaryKey primaryKey;
    private Map<String, JsonArray> fkValueByRelationshipName = new HashMap<String, JsonArray>();
    private AppVersion appVersion;
    private String errMsg;
    private String action;
    private int uploadedOrder;
    private JsonElement rowId;
    private Long httpStatusCode;
    private Long opstatus;
    private long objectMaxDeltaValue;
    private boolean isRootNode = false;
    private int numberOfColumnsInResponse;
    private RowProcessingStrategy rowSummaryStrategy;

    public RowMetadata() {
    }

    public RowMetadata(ObjectMetadata objectMetadata, String objectName) {
        this.objectMetadata = objectMetadata;
        this.objectName = objectName;
    }

    void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = new StringBuilder().append(checkSum);
    }

    void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getCheckSum() {
        return this.checkSum != null ? this.checkSum.toString() : null;
    }

    public StringBuilder getCheckSumAsStringBuffer() {
        return this.checkSum;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    void setInputFkValue(String relationshipName, JsonArray fkValues) {
        this.fkValueByRelationshipName.put(relationshipName, fkValues);
    }

    void setAppVersion(AppVersion appVersion) {
        this.appVersion = appVersion;
    }

    public AppVersion getAppVersion() {
        return this.appVersion;
    }

    public JsonArray getFkValues(String relationshipName) {
        return this.fkValueByRelationshipName.get(relationshipName);
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public JsonObject getAsJsonObject() {
        return this.objectMetadata.isOffline() ? this.getOfflineRowMetadata() : this.getOnlineRowMetadata();
    }

    private JsonObject getOnlineRowMetadata() {
        JsonObject onlineRowMetadata = new JsonObject();
        if (this.getRowId() != null) {
            onlineRowMetadata.add("rowId", this.getRowId());
        }
        if (StringUtils.isNotBlank((String)this.getErrMsg())) {
            onlineRowMetadata.addProperty("errmsg", this.getErrMsg());
        }
        onlineRowMetadata.addProperty("opstatus", (Number)this.getOpstatus());
        return onlineRowMetadata;
    }

    private JsonObject getOfflineRowMetadata() {
        JsonObject rowMetadata = this.getOnlineRowMetadata();
        rowMetadata.addProperty("action", this.getAction());
        rowMetadata.addProperty("checksum", this.getCheckSum());
        return rowMetadata;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int getUploadedOrder() {
        return this.uploadedOrder;
    }

    public void setUploadedOrder(int uploadedOrder) {
        this.uploadedOrder = uploadedOrder;
    }

    public JsonElement getRowId() {
        return this.rowId;
    }

    public void setRowId(JsonElement rowId) {
        this.rowId = rowId;
    }

    public void setOpstatus(Long opstatus) {
        this.opstatus = opstatus;
    }

    public void setHttpStatusCode(Long httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    Long getHttpStatusCode() {
        return this.httpStatusCode;
    }

    Long getOpstatus() {
        return this.opstatus;
    }

    public long getObjectMaxDeltaValue() {
        return this.objectMaxDeltaValue;
    }

    public void setObjectMaxDeltaValue(long objectMaxDeltaValue) {
        this.objectMaxDeltaValue = objectMaxDeltaValue;
    }

    public boolean isRootNode() {
        return this.isRootNode;
    }

    public void setRootNode(boolean isRootNode) {
        this.isRootNode = isRootNode;
    }

    public RowProcessingStrategy getRowSummaryStrategy() {
        return this.rowSummaryStrategy;
    }

    public void setRowSummaryStrategy(RowProcessingStrategy rowSummaryStrategy) {
        this.rowSummaryStrategy = rowSummaryStrategy;
    }

    public int getNumberOfColumnsInResponse() {
        return this.numberOfColumnsInResponse;
    }

    public void incrementNumberOfColumnsInResponse() {
        ++this.numberOfColumnsInResponse;
    }
}

