/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.dataaccess.exception.DataAccessException;
import com.konylabs.middleware.common.ActionType;
import com.konylabs.middleware.exceptions.ObjectServicesException;
import com.konylabs.middleware.objservices.runtime.metadata.ObjectMetadata;
import com.konylabs.middleware.objservices.runtime.metadata.ParentChildType;
import com.konylabs.middleware.objservices.runtime.request.PrimaryKey;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.vo.Operationmapping;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.OperationStrategy;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class RowUtil {
    private static final Logger LOGGER = Logger.getLogger(RowUtil.class);

    private RowUtil() {
    }

    public static void fetchAndUpdateInputPrimarykey(JsonObject inputJson, InputPayloadMetadata inputPayloadMetadata, ObjectMetadata objectMetadata, PrimaryKey requestPrimeryKey) {
        LOGGER.debug((Object)" Inside fetchAndUpdateInputPrimarykey()");
        if (!requestPrimeryKey.isEmpty()) {
            List<String> primaryKeys = objectMetadata.getPrimaryKeys();
            for (String primaryKey : primaryKeys) {
                PrimaryKey responsePrimeryKey;
                HashMap<String, JsonElement> responsePk;
                Row responseRow = inputPayloadMetadata.getResponseRowByObjNameInputPk(objectMetadata.getName(), requestPrimeryKey);
                if (responseRow == null || (responsePk = (responsePrimeryKey = PrimaryKey.extractPK(objectMetadata.getPrimaryKeys(), responseRow.getJsonElement().getAsJsonObject())).getPkValues()).get(primaryKey) == null) continue;
                inputJson.add(primaryKey, responsePk.get(primaryKey));
            }
        }
    }

    public static void fetchAndUpdateInputForeignkey(JsonObject inputJson, InputPayloadMetadata inputPayloadMetadata, ObjectMetadata objectMetadata) {
        LOGGER.debug((Object)" Inside fetchAndUpdateInputForeignkey()");
        String objectName = objectMetadata.getName();
        JsonObject requestInput = inputJson;
        List<ParentChildType> parentChildTypeList = inputPayloadMetadata.getParentChildListByChildObjectname(objectName);
        if (parentChildTypeList != null && !parentChildTypeList.isEmpty()) {
            for (ParentChildType parentChildType : parentChildTypeList) {
                Row responseRow;
                List<String> childFieldTypes = parentChildType.getChildFieldTypes();
                JsonArray inputFkValues = new JsonArray();
                for (String childField : childFieldTypes) {
                    if (!requestInput.has(childField)) continue;
                    inputFkValues.add(requestInput.get(childField));
                }
                if (inputFkValues.size() <= 0 || (responseRow = inputPayloadMetadata.getResponseRowByObjNameRelationshipNameInputFk(parentChildType.getParentObjectName(), parentChildType.getRelationshipName(), inputFkValues)) == null) continue;
                JsonObject responseJson = responseRow.getJsonElement().getAsJsonObject();
                List<String> parentFieldTypes = parentChildType.getParentFieldTypes();
                for (int i = 0; i < parentFieldTypes.size(); ++i) {
                    requestInput.add(childFieldTypes.get(i), responseJson.get(parentFieldTypes.get(i)));
                }
            }
        }
    }

    public static Row createResponseRow(Row inputRow, JsonObject responseJsonObject) throws DataAccessException {
        LOGGER.debug((Object)" Inside createResponseRow()");
        RowMetadata inputMetadata = inputRow.getMetadata();
        JsonObject currentObjectJson = RowUtil.prepareResponseJson(inputRow, responseJsonObject, inputMetadata);
        RowMetadata responseMetadata = RowUtil.responseMetadata(inputMetadata, currentObjectJson);
        if (responseJsonObject.has("opstatus")) {
            responseMetadata.setOpstatus(responseJsonObject.get("opstatus").getAsLong());
        }
        Row responseRow = new Row(currentObjectJson);
        responseRow.setMetadata(responseMetadata);
        return responseRow;
    }

    public static RowMetadata responseMetadata(RowMetadata inputMetadata, JsonObject currentObjectJson) {
        AppVersion appVersion = inputMetadata.getAppVersion();
        RowMetadata responseMetadata = new RowMetadata(inputMetadata.getObjectMetadata(), inputMetadata.getObjectName());
        responseMetadata.setAppVersion(appVersion);
        responseMetadata.setOperationId(inputMetadata.getOperationId());
        responseMetadata.setRowId(inputMetadata.getRowId());
        responseMetadata.setPrimaryKey(inputMetadata.getPrimaryKey());
        PrimaryKey primaryKey = PrimaryKey.extractPKHierarchy(responseMetadata.getObjectMetadata(), currentObjectJson);
        if (primaryKey != null && !primaryKey.isEmpty()) {
            responseMetadata.setPrimaryKey(primaryKey);
        }
        if (currentObjectJson.has("_metadata")) {
            JsonObject metadata = currentObjectJson.get("_metadata").getAsJsonObject();
            responseMetadata.setAction(metadata.get("action").getAsString());
            if (metadata.has("checksum")) {
                responseMetadata.setCheckSum(metadata.get("checksum").getAsString());
            }
            currentObjectJson.remove("_metadata");
        }
        return responseMetadata;
    }

    public static JsonObject prepareResponseJson(Row inputRow, JsonObject responseJsonObject, RowMetadata inputMetadata) throws DataAccessException {
        LOGGER.debug((Object)" Inside prepareResponseJson()");
        JsonObject currentResponseJson = responseJsonObject;
        String objectName = inputMetadata.getObjectName();
        if (responseJsonObject.has(objectName)) {
            if (responseJsonObject.get(objectName).isJsonArray()) {
                JsonArray asJsonArray = responseJsonObject.get(objectName).getAsJsonArray();
                currentResponseJson = asJsonArray.size() > 0 ? asJsonArray.get(0).getAsJsonObject() : new JsonObject();
            } else if (responseJsonObject.get(objectName).isJsonObject()) {
                currentResponseJson = responseJsonObject.get(objectName).getAsJsonObject();
            }
        }
        return currentResponseJson;
    }

    public static void updateChecksum(InputPayloadMetadata inputPayloadMetadata, Row inputRow, ObjectMetadata objectMetadata, PrimaryKey requestPrimeryKey) {
        String responseChecksum;
        LOGGER.debug((Object)" Inside updateChecksum()");
        Row responseRow = inputPayloadMetadata.getResponseRowByObjNameInputPk(objectMetadata.getName(), requestPrimeryKey);
        if (responseRow != null && responseRow.getMetadata() != null && (responseChecksum = responseRow.getMetadata().getCheckSum()) != null) {
            inputRow.getMetadata().setCheckSum(responseChecksum);
        }
    }

    public static void setResponseRowWithForeignKey(String objectName, ObjectMetadata objectMetadata, JsonObject inputJson, Row responseRow, InputPayloadMetadata inputPayloadMetadata) {
        LOGGER.debug((Object)" Inside setResponseRowWithForeignKey()");
        List<ParentChildType> parentChildList = objectMetadata.getParentChildList();
        for (ParentChildType parentChildType : parentChildList) {
            String relationshipName = parentChildType.getRelationshipName();
            JsonArray fkValues = new JsonArray();
            List<String> parentFieldTypes = parentChildType.getParentFieldTypes();
            for (String parentField : parentFieldTypes) {
                if (!inputJson.has(parentField)) continue;
                fkValues.add(inputJson.get(parentField));
            }
            inputPayloadMetadata.putResponseRowByObjNameRelationshipNameInputFk(objectName, relationshipName, fkValues, responseRow);
        }
    }

    public static void setResponseRowWithPrimeryKey(String objectName, PrimaryKey requestPrimeryKey, Row responseRow, InputPayloadMetadata inputPayloadMetadata) {
        inputPayloadMetadata.putResponseRowWithObjNameInputPk(objectName, requestPrimeryKey, responseRow);
    }

    public static JsonObject getFailedErrorJson(ObjectServiceResponseData objectServiceResponseData, Row responseRow) {
        LOGGER.debug((Object)" Inside getFailedErrorJson()");
        JsonObject responseJson = responseRow.getJsonElement().getAsJsonObject();
        if (responseJson != null) {
            responseJson.add("_metadata", (JsonElement)responseRow.getMetadata().getAsJsonObject());
        }
        return responseJson;
    }

    public static JsonObject getFailedErrorJson(ObjectServiceResponseData objectServiceResponseData, Row responseRow, String errMsg, long opstatus) {
        LOGGER.debug((Object)" Inside getFailedErrorJson()");
        RowMetadata rowMetadata = responseRow.getMetadata();
        rowMetadata.setErrMsg(errMsg);
        rowMetadata.setOpstatus(opstatus);
        responseRow.setValue("_metadata", (JsonElement)rowMetadata.getAsJsonObject());
        return responseRow.getJsonElement().getAsJsonObject();
    }

    public static JsonObject prepareSuccessResponseJson(ObjectServiceResponseData objectServiceResponseData, Row requestRow, Row responseRow) {
        LOGGER.debug((Object)" Inside prepareSuccessResponseJson()");
        JsonObject metadataJsonElement = null;
        if (responseRow.getMetadata() != null) {
            metadataJsonElement = responseRow.getMetadata().getAsJsonObject();
        }
        JsonObject metadataJson = metadataJsonElement != null ? metadataJsonElement : new JsonObject();
        RowMetadata requestRowMetadata = requestRow.getMetadata();
        List<ParentChildType> pcTypeList = requestRowMetadata.getObjectMetadata().getParentChildList();
        String objectName = requestRowMetadata.getObjectName();
        List<Row> failedRowList = objectServiceResponseData.getAndRemoveFailedRowList(objectName, requestRowMetadata.getPrimaryKey());
        if (failedRowList != null && !failedRowList.isEmpty()) {
            JsonObject intermError = new JsonObject();
            for (Row row : failedRowList) {
                JsonElement order = row.getMetadata().getRowId();
                objectServiceResponseData.incrementTotalRecordCount();
                intermError.addProperty(String.valueOf(order), row.getMetadata().getErrMsg());
            }
            RowUtil.removeFkMap(objectServiceResponseData, requestRowMetadata, pcTypeList, objectName);
            metadataJson.add("intermediateErrors", (JsonElement)intermError);
        }
        responseRow.setValue("_metadata", (JsonElement)metadataJson);
        return responseRow.getJsonElement().getAsJsonObject();
    }

    private static void removeFkMap(ObjectServiceResponseData objectServiceResponseData, RowMetadata requestRowMetadata, List<ParentChildType> pcTypeList, String objectName) {
        LOGGER.debug((Object)" Inside removeFkMap()");
        for (ParentChildType pcType : pcTypeList) {
            objectServiceResponseData.getAndRemoveFailedRowListByFkValues(objectName, pcType.getRelationshipName(), requestRowMetadata.getFkValues(pcType.getRelationshipName()));
        }
    }

    public static Object convertISOToDate(JsonElement jsonEle) {
        try {
            if (jsonEle != null) {
                Calendar cal = DatatypeConverter.parseDateTime((String)jsonEle.getAsString());
                Date date = cal.getTime();
                return date;
            }
            return jsonEle;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.debug((Object)("Unable to convert ISO date format to Date object." + ex));
            return jsonEle.getAsString();
        }
    }

    public static Object getRowElementMetadata(ObjectMetadata objectMetadata, String key) {
        if (objectMetadata != null) {
            if (objectMetadata.getFieldMetadataMap().containsKey(key)) {
                return objectMetadata.getFieldMetadataMap().get(key);
            }
            if (objectMetadata.getChildObjectMetadata().containsKey(key)) {
                return objectMetadata.getChildObjectMetadata().get(key);
            }
        }
        return null;
    }

    public static void putReconciledColumn(JsonObject responseJson, PrimaryKey requestPrimaryKey) {
        for (Map.Entry<String, JsonElement> entry : requestPrimaryKey.getPkValues().entrySet()) {
            JsonElement clientValue = entry.getValue();
            if (clientValue == null || clientValue.isJsonNull() || responseJson.get(entry.getKey()) == null || clientValue.getAsString().equalsIgnoreCase(responseJson.get(entry.getKey()).getAsString())) continue;
            responseJson.add("_" + entry.getKey(), entry.getValue());
        }
    }

    public static void updateChecksumInResponseRowWithPrimeryKey(String objectName, PrimaryKey requestPrimeryKey, Row responseRow, InputPayloadMetadata inputPayloadMetadata) {
        Row responseRowByPk = inputPayloadMetadata.getResponseRowByObjNameInputPk(objectName, requestPrimeryKey);
        if (responseRowByPk != null) {
            if (responseRowByPk.getMetadata() != null) {
                responseRowByPk.getMetadata().setCheckSum(responseRow.getMetadata().getCheckSum());
            }
        } else {
            responseRowByPk = responseRow;
        }
        inputPayloadMetadata.putResponseRowWithObjNameInputPk(objectName, requestPrimeryKey, responseRowByPk);
    }

    public static void copyMetaDataFromInputIfNotPresentInResponse(Row requestRow, JsonObject responseJsonObject) {
        RowMetadata inputMetadata = requestRow.getMetadata();
        if (!responseJsonObject.has("_metadata")) {
            JsonObject metadata = new JsonObject();
            metadata.addProperty("action", ActionType.partialupdate.name());
            metadata.add("rowId", inputMetadata.getRowId());
            responseJsonObject.add("_metadata", (JsonElement)metadata);
        }
    }

    public static String getChecksumFromRow(Row inputRow) {
        return inputRow.getMetadata().getCheckSum();
    }

    public static void setServiceId(RequestContext context, String objectName, String operationId, RowMetadata metadata, Row row) throws AppRegistryException {
        Operationmapping operation = context.getAppMetadata().getOperatonMapingByObjectId(objectName).get(operationId);
        if (operation == null || StringUtils.isBlank((String)operation.getServiceid())) {
            LOGGER.error((Object)"Service is not configured for the operation");
            throw new AppRegistryException("14042", MessageFormat.format(ObjectServicesException.getErrorMessage("14051"), operationId, objectName, metadata.getRowId()));
        }
        row.setValue("serviceID", operation.getServiceid());
    }

    public static OperationStrategy getOperationStratergyByOperationId(String operationId) {
        for (OperationEnum operation : OperationEnum.values()) {
            if (!operation.name().equals(operationId)) continue;
            return operation.getStrategy();
        }
        return null;
    }
}

