/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.request.builder.AbstractConflictResolver;
import com.konylabs.middleware.request.builder.GetAfterConflictResolver;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.builder.RowMetadata;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ServerWinsConflictResolver
extends AbstractConflictResolver {
    private static final Logger LOGGER = Logger.getLogger(ServerWinsConflictResolver.class);

    @Override
    public void resolveClientCreateServerExists(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientCreateServerExists()");
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            if (isSoftDeleted) {
                RowMetadata rowMetadata = requestRow.getMetadata();
                String updateOperationId = OperationEnum.update.name();
                String updateServiceId = ObjectServiceUtil.getServiceId(inputPayloadMetadata.getRequestData().getAppMetadata(), rowMetadata.getObjectName(), updateOperationId);
                requestRow.getMetadata().setOperationId(updateOperationId);
                requestRow.getMetadata().setAction(updateOperationId);
                requestRow.setValue("serviceID", updateServiceId);
                requestRow.setStrategy(OperationEnum.update.getStrategy());
                requestRow.getStrategy().process(requestRow, inputPayloadMetadata, context);
            } else {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, responseRow, parentContext);
            }
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    @Override
    public void resolveClientUpdateServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientUpdateServerUpdate()");
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, responseRow, parentContext);
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    @Override
    public void resolveClientUpdateServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientUpdateServerDelete()");
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            if (isSoftDeleted) {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, this.resultRowOnDelete(requestRow, responseRow), parentContext);
            } else {
                this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, this.resultRowOnDelete(requestRow, requestRow), parentContext);
            }
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    @Override
    public void resolveClientDeleteServerUpdate(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerUpdate()");
        HttpServletRequest httpServletRequest = inputPayloadMetadata.getHttpServletRequest();
        HttpServletResponse httpServletResponse = inputPayloadMetadata.getHttpServletResponse();
        GetAfterConflictResolver rowUploadHandler = (GetAfterConflictResolver)context.get("handler");
        Context parentContext = (Context)context.get("parentContext");
        try {
            this.getAsyncHandler(rowUploadHandler).onSuccess(httpServletRequest, httpServletResponse, responseRow, parentContext);
        }
        catch (Exception ex) {
            rowUploadHandler.onError(httpServletRequest, httpServletResponse, ex, parentContext);
        }
    }

    @Override
    public void resolveClientDeleteServerDelete(Row requestRow, Row responseRow, InputPayloadMetadata inputPayloadMetadata, Context context, boolean isSoftDeleted) {
        LOGGER.debug((Object)" Inside resolveClientDeleteServerNotExists()");
        super.resolveClientDeleteServerDelete(requestRow, responseRow, inputPayloadMetadata, context, isSoftDeleted);
    }
}

