/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.helper.DataFoundationWSHelper;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.controller.impl.DataControllerRequestRowImpl;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.AbstractPayloadParser;
import com.konylabs.middleware.request.builder.AbstractRowProcessingStratergy;
import com.konylabs.middleware.request.builder.InputPayloadMetadata;
import com.konylabs.middleware.request.builder.ObjectServiceRequestData;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.RequestUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SingleRecordPayloadParser
extends AbstractPayloadParser {
    private static final Logger LOGGER = Logger.getLogger(SingleRecordPayloadParser.class);

    public SingleRecordPayloadParser(HttpServletRequest httpServletRequest, RequestContext context, HttpServletResponse httpServletResponse, JsonElement totalPayload, Map<String, String> queryParams) {
        super(httpServletRequest, context, httpServletResponse, totalPayload, queryParams);
    }

    @Override
    public RequestData parse() throws AppRegistryException, MiddlewareException, Exception {
        LOGGER.debug((Object)" Inside parse()");
        ObjectServiceRequestData objectServiceRequestData = new ObjectServiceRequestData(this.context.getAppMetadata());
        InputPayloadMetadata payloadMetadata = new InputPayloadMetadata();
        payloadMetadata.setJsonQueryParam(this.getQueryParams());
        JsonObject inputPayload = this.getTotalPayload() != null ? this.getTotalPayload().getAsJsonObject() : new JsonObject();
        Row inputRow = this.prepareRowWithMetadata(inputPayload);
        payloadMetadata.addRow(inputRow);
        DataControllerRequestRowImpl dcr = new DataControllerRequestRowImpl(inputRow, this.httpServletRequest);
        dcr.setAttribute("tenantBean", this.httpServletRequest.getAttribute("tenantBean"));
        String channel = this.httpServletRequest.getParameter("channel");
        dcr.setAttribute("queryparams", payloadMetadata.getQueryParamMap());
        dcr.setAttribute("gatewaywrapperobject", this.context.getGateWayWrapper());
        dcr.addRequestParam_("channel", channel != null && !channel.trim().isEmpty() ? channel : "rc");
        dcr.getHeaderMap().put("X-Kony-API-Version", inputRow.getMetadata().getAppVersion().getVersion());
        dcr.setAttribute("appregistry_Cache", this.context.getAppCache());
        dcr.setAttribute("metricsBean", this.httpServletRequest.getAttribute("metricsBean"));
        dcr.setAttribute("cacheDirector", RequestUtils.getAttribute((HttpServletRequest)this.httpServletRequest, (String)"cacheDirector"));
        DataFoundationWSHelper.setMapperCallbackHandler(new AbstractRowProcessingStratergy(), inputRow.getMetadata().getObjectMetadata(), dcr);
        if (OperationEnum.delete.name().equals(inputRow.getMetadata().getOperationId())) {
            Map parameterMap = this.httpServletRequest.getParameterMap();
            HashMap urlParams = new HashMap();
            urlParams.putAll(parameterMap);
            String[] filters = (String[])urlParams.get("$filter");
            if (filters != null) {
                String exp = filters[0];
                ObjectServiceUtil.addFilterValues(exp, dcr);
            }
        }
        payloadMetadata.setDCR(dcr);
        objectServiceRequestData.setHttpServletRequest(this.httpServletRequest);
        objectServiceRequestData.setHttpServletResponse(this.httpServletResponse);
        objectServiceRequestData.setInputPayloadMetadata(payloadMetadata);
        return objectServiceRequestData;
    }
}

