/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.appservices.common.util.OnlineResponseFormatter;
import com.konylabs.middleware.appservices.servlet.AppServicesAsyncHandler;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.controller.AppServicesAsyncHandlerChain;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.request.builder.ObjectServiceResponseData;
import com.konylabs.middleware.request.builder.Row;
import com.konylabs.middleware.utilities.ResponseUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SingleRecordProcessAsyncHandler
implements AsyncHandler,
AppServicesAsyncHandlerChain {
    private static final Logger LOGGER = Logger.getLogger(SingleRecordProcessAsyncHandler.class);

    SingleRecordProcessAsyncHandler() {
    }

    @Override
    public void onSuccess(DataControllerRequest dataControllerRequest, DataControllerResponse dataControllerResponse, Context context) {
        long startTimeOfResponseProcessing = System.currentTimeMillis();
        ObjectServiceResponseData objectServiceResponseData = (ObjectServiceResponseData)context.get("objectServiceResponseData");
        HttpServletRequest httpServletRequest = (HttpServletRequest)context.get("httpServletRequest");
        HttpServletResponse httpServletResponse = (HttpServletResponse)context.get("httpServletResponse");
        Context parentContext = (Context)context.get("parentContext");
        AppServicesAsyncHandler<ObjectServiceResponseData> inputHandler = this.getParentHandler(parentContext);
        try {
            ResponseUtils.addResponseHeaders((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Map)dataControllerResponse.getDeviceHeaders());
            Object result = dataControllerResponse.getAttribute("chunkedresults_json");
            JsonObject responseJsonObject = new JsonParser().parse(result.toString()).getAsJsonObject();
            Row responseRow = new Row(responseJsonObject);
            String prepareJsonResponse = OnlineResponseFormatter.prepareJsonResponse(responseRow, dataControllerRequest);
            MetricsUtils.addResponseInfoToMetricsBean(httpServletRequest, startTimeOfResponseProcessing, responseJsonObject, 1, null, null);
            objectServiceResponseData.setResponseStream(prepareJsonResponse);
            inputHandler.onSuccess(httpServletRequest, httpServletResponse, objectServiceResponseData, parentContext);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Exception occurred while processing the request ", (Throwable)exception);
            inputHandler.onError(httpServletRequest, httpServletResponse, exception, parentContext);
        }
    }

    @Override
    public void onError(DataControllerRequest request, DataControllerResponse response, MiddlewareException exception, Context context) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)context.get("httpServletRequest");
        HttpServletResponse httpServletResponse = (HttpServletResponse)context.get("httpServletResponse");
        Context parentContext = (Context)context.get("parentContext");
        MetricsUtils.addResponseInfoToMetricsBean(httpServletRequest, 0L, null, 0, exception.getMessage(), exception.getStackTrace().toString());
        this.getParentHandler(parentContext).onError(httpServletRequest, httpServletResponse, (Exception)((Object)exception), parentContext);
    }

    public AppServicesAsyncHandler<ObjectServiceResponseData> getParentHandler(Context parentContext) {
        return (AppServicesAsyncHandler)parentContext.get("handler");
    }
}

