/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.builder;

import com.konylabs.middleware.api.processor.impl.ProcessorInfo;
import com.konylabs.middleware.appservices.common.constants.OperationEnum;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.mbaas.MBAASLogicalUrlEnum;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.BinaryUriContext;
import com.konylabs.middleware.request.builder.IntegrationServiceUriContext;
import com.konylabs.middleware.request.builder.MetadataUriContext;
import com.konylabs.middleware.request.builder.ObjectServiceUriContext;
import com.konylabs.middleware.request.builder.ObjectsUriContext;
import com.konylabs.middleware.request.builder.OperationsUriContext;
import com.konylabs.middleware.request.builder.RequestBuilder;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.RequestValidator;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class UriContext {
    private static final Logger LOGGER = Logger.getLogger(UriContext.class);
    private final String[] uriParams;

    protected UriContext(String[] uriParams) {
        this.uriParams = uriParams == null ? new String[]{} : uriParams;
    }

    public String[] getUriParams() {
        return this.uriParams;
    }

    public abstract RequestBuilder getBuilder();

    public abstract RequestValidator getRequestValidator(RequestContext var1);

    public void prepareRequestContext(HttpServletRequest httpServletRequest, RequestContext requestContext) {
        String xKonyAuthHeader = httpServletRequest.getHeader("X-Kony-Authorization");
        if (StringUtils.isNotBlank((String)xKonyAuthHeader)) {
            requestContext.setAuthHeader(xKonyAuthHeader);
        } else {
            requestContext.setAuthHeader(httpServletRequest.getHeader("Authorization"));
        }
        requestContext.setRequestedMethod(httpServletRequest.getMethod());
        requestContext.setRequestOverrideMethod(ObjectServiceUtil.getOverrideMethod(httpServletRequest));
        requestContext.setRequestedUrl(httpServletRequest.getRequestURL().toString());
        requestContext.setRequestId(MiddlewareUtils.getRequestId(httpServletRequest));
        requestContext.setServiceCategory(this.getIdentityResourceServiceType());
        String requestType = this.isGetCall(requestContext) ? "download" : "upload";
        requestContext.setRequestType(requestType);
        String[] uriparam = this.getUriParams();
        if (this.getUriParams().length > 0) {
            String appId = uriparam[0];
            String version = MiddlewareUtils.getRequestedVersion(httpServletRequest, requestContext.getAppCache(), appId);
            requestContext.setRequestedAppVersion(version);
            requestContext.setAppId(appId);
            requestContext.setApiVersion(version);
        }
    }

    public String getLogicalResourceUrl() {
        return MBAASLogicalUrlEnum.INTEGRATION_LOGICAL_ADMIN_URL.getResourcePath();
    }

    public String getIdentityResourceServiceType() {
        return "ObjectService";
    }

    public boolean isMetadata() {
        return false;
    }

    public ProcessorInfo getCustomProcesorInfo(RequestContext requestContext) {
        return null;
    }

    public static UriContext getUriContextByType(String contextType, String[] uriParams) throws AppRegistryException {
        if ("integration".equalsIgnoreCase(contextType)) {
            return new IntegrationServiceUriContext(uriParams);
        }
        if ("objectService".equalsIgnoreCase(contextType)) {
            return new ObjectServiceUriContext(uriParams);
        }
        if ("binary".equalsIgnoreCase(contextType)) {
            return new BinaryUriContext(uriParams);
        }
        if ("operations".equalsIgnoreCase(contextType)) {
            return new OperationsUriContext(uriParams);
        }
        if ("objects".equalsIgnoreCase(contextType)) {
            return new ObjectsUriContext(uriParams);
        }
        if ("metadata".equalsIgnoreCase(contextType)) {
            return new MetadataUriContext(uriParams);
        }
        String errorCode = "14045";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"invalid_url");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void prepareRequestContextForObjectService(HttpServletRequest httpServletRequest, RequestContext requestContext) {
        LOGGER.debug((Object)"Inside prepareRequestContextForObjectService method");
        String overrideMethod = ObjectServiceUtil.getOverrideMethod(httpServletRequest);
        String method = httpServletRequest.getMethod();
        LOGGER.debug((Object)("Requested method: " + method));
        if ("upload".equalsIgnoreCase(overrideMethod)) {
            requestContext.setBulkRequest(true);
        } else if (StringUtils.isNotBlank((String)overrideMethod)) {
            LOGGER.debug((Object)("Found X-HTTP-Method-Override header: " + overrideMethod));
            method = overrideMethod;
        }
        requestContext.setRequestedMethod(method);
        requestContext.setDefaultOperation(OperationEnum.getObjectOperationByHttpmethod(requestContext.getRequestedMethod()).getOperationName());
        requestContext.setResourceName("objects");
    }

    protected void prepareRequestContextForObjects(RequestContext requestContext) {
        LOGGER.debug((Object)"Inside prepareRequestContextForObjects method");
        if (this.getUriParams().length > 1) {
            requestContext.setObjectId(this.getUriParams()[1]);
        }
        StringBuilder resourceName = new StringBuilder("objects").append(".").append(requestContext.getObjectId());
        if (!requestContext.isBulkRequest()) {
            resourceName.append(".").append(requestContext.getDefaultOperation());
        }
        requestContext.setResourceName(resourceName.toString());
    }

    private boolean isGetCall(RequestContext requestContext) {
        return OperationEnum.get.getOperationName().equalsIgnoreCase(requestContext.getRequestedMethod()) || OperationEnum.get.getOperationName().equalsIgnoreCase(requestContext.getRequestOverrideMethod());
    }
}

