/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.parser;

import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.IntegrationServiceUriContext;
import com.konylabs.middleware.request.builder.MetadataUriContext;
import com.konylabs.middleware.request.builder.ObjectServiceUriContext;
import com.konylabs.middleware.request.builder.UriContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;

public class UriParser {
    private static UriParser uriParser = new UriParser();

    public static UriParser getInstance() {
        return uriParser;
    }

    public UriContext parse(HttpServletRequest request) throws AppRegistryException {
        return this.parseUri(request.getRequestURI(), request.getContextPath());
    }

    public UriContext parseUri(String requestURI, String contextPath) throws AppRegistryException {
        requestURI = ObjectServiceUtil.removeSlashAtFirst(requestURI);
        contextPath = ObjectServiceUtil.removeSlashAtFirst(contextPath);
        String metadataUri = contextPath + ObjectServiceUtil.getAppservicesMetadataUrl();
        String dataUri = contextPath + ObjectServiceUtil.getAppservicesDataUrl();
        Object[] uriParams = null;
        UriContext uriContext = null;
        if (requestURI.startsWith(dataUri)) {
            uriParams = requestURI.replaceFirst(dataUri, "").split("/");
            if (uriParams.length == 1) {
                uriContext = new ObjectServiceUriContext((String[])uriParams);
            } else if (uriParams.length > 1) {
                uriContext = UriContext.getUriContextByType(uriParams[1], (String[])ArrayUtils.removeElement((Object[])uriParams, (Object)uriParams[1]));
            }
        } else if (requestURI.startsWith(metadataUri)) {
            uriParams = requestURI.replaceFirst(metadataUri, "").split("/");
            uriContext = new MetadataUriContext((String[])uriParams);
        } else {
            String uriWithoutContext = requestURI.replaceFirst(contextPath, "");
            uriWithoutContext = ObjectServiceUtil.removeSlashAtFirst(uriWithoutContext);
            uriParams = uriWithoutContext.split("/");
            uriContext = new IntegrationServiceUriContext((String[])uriParams);
        }
        return uriContext;
    }
}

