/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.validator;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.RequestValidator;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractRequestValidator
implements RequestValidator {
    private static final Logger LOGGER = Logger.getLogger(AbstractRequestValidator.class);

    protected void validateAppId(RequestContext requestContext) throws AppRegistryException {
        AppVersion appVersion = requestContext.getAppVersion();
        if (appVersion.getAppId() == null) {
            LOGGER.error((Object)("Application not found with app version: " + appVersion));
            this.throwAppIdNotfoundError();
        }
        try {
            if (requestContext.getAppMetadata() == null) {
                LOGGER.error((Object)("App Metadata not found with app version : " + appVersion));
                this.throwAppIdOrVersionNotExistsError(requestContext);
            }
        }
        catch (AppRegistryException e) {
            LOGGER.error((Object)"Error while trying to instantiate object def", (Throwable)e);
            this.throwAppIdOrVersionNotExistsError(requestContext);
        }
    }

    protected void throwAppIdOrVersionNotExistsError(RequestContext validatorContext) throws AppRegistryException {
        String availableAPIVersion = MiddlewareUtils.getApplicationAvailableHigherVersion(validatorContext.getAppCache(), validatorContext.getAppId());
        if (StringUtils.isBlank((String)validatorContext.getRequestedAppVersion()) || StringUtils.isBlank((String)availableAPIVersion)) {
            this.throwAppNotFoundWithGivenId();
        } else {
            this.throwAppIdNotFoundWithGivenVersion();
        }
    }

    protected void throwServiceNotFoundWithIdError() throws AppRegistryException {
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_service_exists_withid");
        String errorCode = "10102";
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void throwServiceIdNotFoundError() throws AppRegistryException {
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"app_id_service_id_not_found");
        String errorCode = "14016";
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void throwAppIdNotFoundWithGivenVersion() throws AppRegistryException {
        String errorCode = "10107";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_app_exists_withid_version");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void throwAppNotFoundWithGivenId() throws AppRegistryException {
        String errorCode = "10101";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_app_exists_withid");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void throwAppIdNotfoundError() throws AppRegistryException {
        String errorCode = "5002";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"app_id_service_id_not_found");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    protected void throwMethodNotSupportedError() throws AppRegistryException {
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"method_not_supported_for_service");
        String errorCode = "14047";
        throw new AppRegistryException(errorCode, errorMessage, 405);
    }
}

