/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.validator;

import com.kony.adapter.DataAdapterFactory;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.ObjectServiceRequestValidator;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BulkOperationRequestValidator
extends ObjectServiceRequestValidator {
    private static final Logger LOGGER = Logger.getLogger(BulkOperationRequestValidator.class);

    @Override
    public void postValidation(HttpServletRequest request, RequestContext requestContext) throws AppRegistryException {
        LOGGER.debug((Object)" Inside postValidation()");
        super.postValidation(request, requestContext);
        StringBuilder sb = new StringBuilder("objects");
        sb.append(".").append(requestContext.getObjectId());
        sb.append(".").append(requestContext.getDefaultOperation());
        requestContext.setResourceName(sb.toString());
        if (!requestContext.isBulkRequest()) {
            requestContext.setObjectLevelCall(true);
            ApplicationMetadata appMetadata = requestContext.getAppMetadata();
            String serviceId = appMetadata.getOperatonMapingByObjectId(requestContext.getObjectId()).get(requestContext.getDefaultOperation()).getServiceid();
            requestContext.setServiceId(serviceId);
            Service service = requestContext.getAppMetadata().getServiceMetadata(requestContext.getServiceId()).getService();
            requestContext.setSecurityLevel(service.getSecurity());
            String adapterType = service.getServiceConfig().getConfigParamValue("adaptertype");
            if (DataAdapterFactory.DataAdapterType.KONY_INTEGRATION_SERVICE.toString().equals(adapterType)) {
                service = MiddlewareUtils.getIntegrationServiceFromSDO(requestContext.getAppId(), requestContext.getServiceId(), requestContext.getAppVersion().getVersion(), service);
            }
            requestContext.setRequestPassThrough(MiddlewareUtils.isRequestPassThrough(service));
            boolean responsePassThrough = "bytes".equals(request.getParameter("type")) || MiddlewareUtils.isResponsePassThrough(service);
            requestContext.setResponsePassThrough(responsePassThrough);
        }
    }

    @Override
    protected void validateObjects(String objectId, String operationId, ApplicationMetadata appMetadata) throws AppRegistryException {
        if (StringUtils.isBlank((String)objectId)) {
            String errorCode = "14039";
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"object_id_not_found");
            throw new AppRegistryException(errorCode, errorMessage);
        }
        if (appMetadata != null && !appMetadata.getOperatonMapingsMap().containsKey(objectId)) {
            LOGGER.error((Object)String.format("Object service not with object id : %s", objectId));
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_object_exists_with_id");
            String errorCode = "14040";
            throw new AppRegistryException(errorCode, errorMessage);
        }
        LOGGER.debug((Object)("requested objectId: " + objectId));
    }
}

