/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.validator;

import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.mbaas.MBAASLogicalUrlEnum;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.AbstractRequestValidator;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntegrationRequestValidator
extends AbstractRequestValidator {
    private static final Logger logger = Logger.getLogger(IntegrationRequestValidator.class);

    @Override
    public void validateRequest(RequestContext requestContext) throws AppRegistryException {
        this.validateAppId(requestContext);
        this.validateServiceId(requestContext);
        logger.debug((Object)"validation completed no errors found for the integration service request");
    }

    protected String validateServiceId(RequestContext validatorContext) throws AppRegistryException {
        ServiceMetadata serviceMetadata;
        String serviceId = validatorContext.getServiceId();
        if (StringUtils.isBlank((String)serviceId)) {
            this.throwServiceIdNotFoundError();
        }
        if ((serviceMetadata = validatorContext.getAppMetadata().getServiceMetadata(serviceId)) == null) {
            this.throwServiceNotFoundWithIdError();
        }
        String supportedVerbs = serviceMetadata.getSupportedMethods();
        String requestedMethod = validatorContext.getRequestedMethod();
        if (requestedMethod != null && !IntegrationRequestValidator.isRequestedMethodAllowed(requestedMethod, supportedVerbs)) {
            this.throwMethodNotSupportedError();
        }
        return serviceId;
    }

    public static boolean isRequestedMethodAllowed(String requestedMethod, String supportedVerbs) {
        List<String> items = Arrays.asList(supportedVerbs.split(","));
        boolean isRequestedMethodConfigured = items.contains(requestedMethod);
        boolean isHttpGetSupported = ConfigUtility.getBoolean((String)"KONY_SERVER_HTTP_GET_SUPPORT", (boolean)false);
        if (!isRequestedMethodConfigured && HttpMethods.GET.nameEquals(requestedMethod) && isHttpGetSupported) {
            return true;
        }
        return isRequestedMethodConfigured;
    }

    @Override
    public void postValidation(HttpServletRequest request, RequestContext requestContext) {
        Service service = requestContext.getAppMetadata().getServiceMetadata(requestContext.getServiceId()).getService();
        requestContext.setSecurityLevel(service.getSecurity());
        MBAASLogicalUrlEnum logicalUrl = MBAASLogicalUrlEnum.INTEGRATION_LOGICAL_USER_URL;
        if (request.getHeader("x-kony-server-console") != null) {
            logicalUrl = MBAASLogicalUrlEnum.INTEGRATION_LOGICAL_ADMIN_URL;
        }
        requestContext.setLogicalUrl(logicalUrl);
        requestContext.setResourceName(requestContext.getServiceId());
        requestContext.setRequestPassThrough(MiddlewareUtils.isRequestPassThrough(service));
        requestContext.setResponsePassThrough(MiddlewareUtils.isResponsePassThrough(service));
    }
}

