/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.validator;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.mbaas.MBAASLogicalUrlEnum;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.validator.AbstractRequestValidator;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ObjectServiceRequestValidator
extends AbstractRequestValidator {
    private static final Logger logger = Logger.getLogger(ObjectServiceRequestValidator.class);

    @Override
    public void validateRequest(RequestContext requestContext) throws AppRegistryException {
        AppVersion appVersion = requestContext.getAppVersion();
        String objectId = requestContext.getObjectId();
        String operationId = requestContext.getDefaultOperation();
        this.validateAppId(requestContext);
        logger.debug((Object)("requested appId: " + appVersion.getAppId() + ", requested appVersion: " + appVersion.getVersion()));
        this.validateObjects(objectId, operationId, requestContext.getAppMetadata());
    }

    protected void validateObjects(String objectId, String operationId, ApplicationMetadata appMetadata) throws AppRegistryException {
    }

    @Override
    protected void throwAppIdNotfoundError() throws AppRegistryException {
        String errorCode = "14043";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"object_service_not_found");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    @Override
    protected void throwAppNotFoundWithGivenId() throws AppRegistryException {
        String errorCode = "14044";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"object_service_not_exists");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    @Override
    protected void throwAppIdNotFoundWithGivenVersion() throws AppRegistryException {
        String errorCode = "10108";
        String errorMessage = AppRegistryException.getErrorMessageForKey((String)"object_service_not_exists_given_id");
        throw new AppRegistryException(errorCode, errorMessage);
    }

    @Override
    public void postValidation(HttpServletRequest request, RequestContext requestContext) throws AppRegistryException {
        ApplicationMetadata appMetadata = requestContext.getAppMetadata();
        ConfigParam configParam = appMetadata.getConfigParamByParamName("metadataSecurity");
        if (configParam != null) {
            requestContext.setSecurityLevel(configParam.getValue());
        }
        requestContext.setLogicalUrl(MBAASLogicalUrlEnum.METADATA_LOGICAL_USER_URL);
    }
}

