/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.request.validator;

import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.request.validator.BulkOperationRequestValidator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ObjectsRequestValidator
extends BulkOperationRequestValidator {
    private static final Logger LOGGER = Logger.getLogger(ObjectsRequestValidator.class);

    @Override
    protected void validateObjects(String objectId, String operationId, ApplicationMetadata appMetadata) throws AppRegistryException {
        super.validateObjects(objectId, operationId, appMetadata);
        if (!appMetadata.getOperatonMapingByObjectId(objectId).containsKey(operationId)) {
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"operation_not_found");
            String errorCode = "14041";
            LOGGER.error((Object)("Operation: " + operationId + " not found in given object: " + objectId));
            throw new AppRegistryException(errorCode, errorMessage);
        }
        String serviceId = appMetadata.getOperatonMapingByObjectId(objectId).get(operationId).getServiceid();
        if (StringUtils.isBlank((String)serviceId)) {
            String errorMessage = AppRegistryException.getErrorMessageForKey((String)"service_not_configured_operation");
            String errorCode = "14042";
            LOGGER.error((Object)("Service: " + serviceId + " not found in given object: " + objectId));
            throw new AppRegistryException(errorCode, errorMessage);
        }
    }
}

