/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.response;

import com.kony.api.auth.common.Integrity;
import com.kony.api.auth.common.ResultCode;
import com.kony.api.gateway.Gateway;
import com.kony.api.gateway.GatewayException;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HttpIntegrityPrintWriter
extends PrintWriter {
    private static final Logger LOGGER = Logger.getLogger(HttpIntegrityPrintWriter.class);
    private final Gateway mbaasGateway;
    private final String integrityHeader;
    private final String mimeType;
    private final HttpServletResponse response;

    public HttpIntegrityPrintWriter(HttpServletResponse response, Gateway mbaasGateway, String integrityHeader, String mimeType) throws IOException {
        super(response.getWriter());
        this.response = response;
        this.mbaasGateway = mbaasGateway;
        this.integrityHeader = integrityHeader;
        this.mimeType = mimeType;
    }

    @Override
    public void write(String content) {
        LOGGER.debug((Object)"Inside write method of HttpIntegrityPrintWriter class");
        try {
            Integrity integrity = null;
            if (StringUtils.isNotBlank((String)content) && !"multipart/form-data".equalsIgnoreCase(this.mimeType)) {
                integrity = this.mbaasGateway.generateResponseIntegrity(this.integrityHeader, content.getBytes(StandardCharsets.UTF_8), this.mimeType);
                this.response.setHeader("Access-Control-Expose-Headers", "X-Kony-Integrity");
                this.response.setHeader("X-Kony-Integrity", integrity.getIntegrityHash());
                super.write(IOUtils.toString((InputStream)integrity.getInputStream(), (Charset)StandardCharsets.UTF_8));
            }
            if ("multipart/form-data".equalsIgnoreCase(this.mimeType)) {
                integrity = this.mbaasGateway.generateResponseIntegrity(this.integrityHeader, null, "multipart/form-data");
                this.response.setHeader("Access-Control-Expose-Headers", "X-Kony-Integrity");
                this.response.setHeader("X-Kony-Integrity", integrity.getIntegrityHash());
            }
        }
        catch (GatewayException | IOException e) {
            LOGGER.error((Object)"Error occurred while validating integrity on response", e);
            MiddlewareException me = new MiddlewareException(String.valueOf(ResultCode.FAILURE_GENERATE_INTEGRITY_HEADER.getCode()), ResultCode.FAILURE_GENERATE_INTEGRITY_HEADER.getMessage(), e);
            super.write(ObjectServiceUtil.getErrorMsgByMiddlewareException(me));
        }
    }
}

