/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.sequence.impl;

import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.config.DataControllerConfigDocument;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.DataController;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.controller.impl.DataControllerResponseImpl;
import com.konylabs.middleware.exceptions.ControllerException;
import com.konylabs.middleware.exceptions.ControllerInitializationException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.exceptions.SequenceException;
import com.konylabs.middleware.exceptions.SequenceInitializationException;
import com.konylabs.middleware.processor.AsyncProcessor;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.sequence.AsyncSequence;
import com.konylabs.middleware.sequence.Sequence;
import com.konylabs.middleware.sequence.impl.ProcessorAsyncHandler;
import com.konylabs.middleware.sequence.impl.SequenceImplAsyncHandler;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.TemplateUtils;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class SequenceImpl
implements Sequence,
AsyncSequence {
    private DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration sconfig = null;
    private boolean initialized = false;
    private DataController dataController = null;
    private boolean checkMetadata = false;
    private static final String COND_EVAL_TEMPLATE = "#if(${cond}) true #else false #end";
    private static final Logger LOGGER = Logger.getLogger(SequenceImpl.class);
    private static final SequenceImplAsyncHandler seqAsyncHandler = new SequenceImplAsyncHandler();
    private static final ProcessorAsyncHandler processorAsyncHandler = new ProcessorAsyncHandler();

    @Override
    public void initConfig(DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration sc, DataController dc) throws SequenceInitializationException {
        if (this.initialized) {
            return;
        }
        this.dataController = dc;
        this.sconfig = sc;
        String metadataCheck = this.sconfig.getCheckMetadata();
        if (metadataCheck != null && metadataCheck.equals("true")) {
            this.checkMetadata = true;
        }
        this.initialized = true;
    }

    @Override
    public DataControllerResponse execute(DataControllerRequest controllerRequest) throws SequenceInitializationException, SequenceException {
        DataControllerResponseImpl dcResponse = new DataControllerResponseImpl();
        String seqName = this.sconfig.getName();
        DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration.ProcessorRef[] pra = this.sconfig.getProcessorRefArray();
        String processorName = null;
        try {
            for (int i = 0; i < pra.length; ++i) {
                processorName = pra[i].getName().trim();
                LOGGER.debug((Object)("Executing processor " + processorName));
                if (SequenceImpl.isProcessorConditionSatisfied(pra[i], controllerRequest)) {
                    Processor processor = this.dataController.getProcessor(processorName);
                    this.executeProcessor(controllerRequest, (DataControllerResponse)dcResponse, seqName, processorName, processor);
                    continue;
                }
                LOGGER.debug((Object)("Did not execute " + processorName + " as condition did not met the criteria."));
            }
        }
        catch (ControllerException ce) {
            throw new SequenceException(seqName, processorName, ce.getErrorCode(), ce.getMessage());
        }
        catch (ControllerInitializationException ce) {
            throw new SequenceInitializationException(seqName, processorName, ce.getErrorCode(), ce.getMessage());
        }
        return dcResponse;
    }

    @Override
    public void execute(DataControllerRequest controllerRequest, Context parentContext) {
        DataControllerResponseImpl dcResponse = new DataControllerResponseImpl();
        String seqName = this.sconfig.getName();
        DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration.ProcessorRef[] pra = this.sconfig.getProcessorRefArray();
        this.executeAsync(seqName, pra, controllerRequest, (DataControllerResponse)dcResponse, 0, parentContext);
    }

    protected void executeAsync(String seqName, DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration.ProcessorRef[] processorRefArray, DataControllerRequest request, DataControllerResponse response, int index, Context parentContext) {
        AsyncHandler parentHandler = (AsyncHandler)parentContext.get("handler");
        Context context = new Context();
        if (index >= processorRefArray.length) {
            parentHandler.onSuccess(request, response, parentContext);
            return;
        }
        String processorName = processorRefArray[index].getName().trim();
        context.put("seqName", (Object)seqName);
        context.put("processorName", (Object)processorName);
        context.put("index", (Object)index);
        context.put("processorRefArray", (Object)processorRefArray);
        LOGGER.debug((Object)("Executing processor " + processorName));
        context.put("sequenceImpl", (Object)this);
        context.put("parentContext", (Object)parentContext);
        context.put("handler", (Object)seqAsyncHandler);
        if (!SequenceImpl.isProcessorConditionSatisfied(processorRefArray[index], request)) {
            LOGGER.debug((Object)("Did not execute " + processorName + " as condition did not met the criteria."));
            this.executeAsync(seqName, processorRefArray, request, response, index + 1, parentContext);
            return;
        }
        try {
            Processor processor = this.dataController.getProcessor(processorName);
            if (processor instanceof AsyncProcessor) {
                this.executeProcessorAsync(request, response, seqName, processorName, (AsyncProcessor)processor, context);
            } else {
                this.executeProcessor(request, response, seqName, processorName, processor);
                this.executeAsync(seqName, processorRefArray, request, response, index + 1, parentContext);
            }
        }
        catch (ControllerInitializationException e) {
            parentHandler.onError(request, response, (MiddlewareException)new SequenceInitializationException(seqName, processorName, e.getErrorCode(), e.getMessage()), context);
        }
        catch (ControllerException e) {
            parentHandler.onError(request, response, (MiddlewareException)((Object)new SequenceException(seqName, processorName, e.getErrorCode(), e.getMessage())), context);
        }
        catch (SequenceException e) {
            parentHandler.onError(request, response, (MiddlewareException)((Object)e), context);
        }
    }

    protected static boolean isProcessorConditionSatisfied(DataControllerConfigDocument.DataControllerConfig.SequenceConfiguration.ProcessorRef processorRef, DataControllerRequest controllerRequest) {
        String condition = processorRef.getCondition();
        if (StringUtils.isBlank((String)condition)) {
            return true;
        }
        VelocityContext evalContext = SequenceImpl.getEvalContext(controllerRequest);
        return SequenceImpl.evalCondition(condition, evalContext);
    }

    protected void executeProcessor(DataControllerRequest controllerRequest, DataControllerResponse dcResponse, String seqName, String processorName, Processor processor) throws ControllerException, SequenceException {
        try {
            this.checkMetadata(controllerRequest, seqName, processorName);
            LOGGER.debug((Object)("Executing processor " + processorName));
            processor.execute(controllerRequest, dcResponse);
        }
        catch (ProcessorException pe) {
            LOGGER.error((Object)pe.getMessage(), (Throwable)pe);
            throw new SequenceException(seqName, processorName, pe.getHttpStatusCode(), pe.getErrorCode(), pe.getMessage(), (Exception)((Object)pe));
        }
    }

    protected void executeProcessorAsync(DataControllerRequest controllerRequest, DataControllerResponse dcResponse, String seqName, String processorName, AsyncProcessor processor, Context parentContext) throws ControllerException, SequenceException {
        this.checkMetadata(controllerRequest, seqName, processorName);
        LOGGER.debug((Object)("Executing processor " + processorName));
        Context context = new Context();
        context.put("parentContext", (Object)parentContext);
        context.put("handler", (Object)processorAsyncHandler);
        processor.execute(controllerRequest, dcResponse, context);
    }

    protected void checkMetadata(DataControllerRequest controllerRequest, String seqName, String processorName) throws ControllerException, SequenceException {
        if (this.checkMetadata && !this.checkMetadata(controllerRequest, this.dataController.getProcessorConfiguration(processorName))) {
            LOGGER.error((Object)("Metadata mismatch: Either request,session or context data doesn't match with metadata configuration in processor " + processorName));
            throw new SequenceException(seqName, processorName, "5104", "Metadata mismatch: Either request,session or context data doesn't match with metadata configuration");
        }
    }

    protected static VelocityContext getEvalContext(DataControllerRequest controllerRequest) {
        String key;
        VelocityContext evalContext = new VelocityContext();
        Iterator it = controllerRequest.getParameterNames();
        while (it.hasNext()) {
            key = (String)it.next();
            evalContext.put(key, (Object)controllerRequest.getParameter(key));
        }
        it = controllerRequest.getAttributeNames();
        while (it.hasNext()) {
            key = (String)it.next();
            evalContext.put(key, controllerRequest.getAttribute(key));
        }
        return evalContext;
    }

    protected static boolean evalCondition(String condition, VelocityContext evalContext) {
        try {
            String template = COND_EVAL_TEMPLATE.replace("${cond}", condition);
            String strResult = TemplateUtils.evaluateTemplate(template, "sequenceCondition", evalContext);
            return strResult.contains("true");
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean checkMetadata(DataControllerRequest request, DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration pc) {
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.ContextMetadata cm;
        String excludedValues;
        String name;
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.SessionMetadata sm;
        DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.RequestMetadata rm = pc.getRequestMetadata();
        if (rm != null) {
            DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.RequestMetadata.Param[] param = rm.getParamArray();
            for (int i = 0; i < param.length; ++i) {
                String name2 = param[i].getName();
                String excludedValues2 = param[i].getExcludedValues();
                if (!request.containsKeyInRequest(name2)) {
                    LOGGER.error((Object)("Metadata Mismatch: " + name2 + " doesn't exist in request"));
                    return false;
                }
                if (request.getParameter(name2) != null || !excludedValues2.contains("null")) continue;
                LOGGER.error((Object)("Metadata Mismatch: Value for " + name2 + " in request is null"));
                return false;
            }
        }
        if ((sm = pc.getSessionMetadata()) != null) {
            Session session = request.getSession();
            DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.SessionMetadata.Param[] sparam = sm.getParamArray();
            for (int i = 0; i < sparam.length; ++i) {
                name = sparam[i].getName();
                excludedValues = sparam[i].getExcludedValues();
                if (!session.containsKey(name)) {
                    LOGGER.error((Object)("Metadata Mismatch: " + name + " doesn't exists in session"));
                    return false;
                }
                if (session.getAttribute(name) != null || !excludedValues.contains("null")) continue;
                LOGGER.error((Object)("Metadata Mismatch: Value for " + name + " in session is null"));
                return false;
            }
        }
        if ((cm = pc.getContextMetadata()) != null) {
            DataControllerConfigDocument.DataControllerConfig.ProcessorConfiguration.ContextMetadata.Param[] cparam = cm.getParamArray();
            for (int i = 0; i < cparam.length; ++i) {
                name = cparam[i].getName();
                excludedValues = cparam[i].getExcludedValues();
                if (!request.containsKeyInRequestContext(name)) {
                    LOGGER.error((Object)("Metadata mismatch: " + name + " doesn't exists in request context"));
                    return false;
                }
                if (request.getAttribute(name) != null || !excludedValues.contains("null")) continue;
                LOGGER.error((Object)("Metadata mismatch: Value for " + name + " in context is null"));
                return false;
            }
        }
        return true;
    }
}

