/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.service;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.ServerCertificateDAO;
import com.kony.middleware.dbcommons.entity.ServerCertificate;
import com.kony.middleware.dbcommons.entity.TimerNotification;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.jsonpath.JsonUtil;
import com.konylabs.middleware.asset.AssetManager;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.classloader.resources.ConfigurationPropertiesManager;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterTask;
import com.konylabs.middleware.controller.CacheUpdateHandler;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.ApplicationInfo;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.registry.impl.ApplicationHelper;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.service.TimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.TimerDataObject;
import com.konylabs.middleware.utilities.DBUtils;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public abstract class AbstractTimerCacheUpdateService
implements TimerCacheUpdateService {
    private static final Logger LOGGER = Logger.getLogger(AbstractTimerCacheUpdateService.class);
    protected WritableTenantEnvManager tenantEnvManager;
    protected String tenantIdentifier;
    protected String schemaName;

    public AbstractTimerCacheUpdateService(String schemaName) {
        this.schemaName = schemaName;
    }

    public AbstractTimerCacheUpdateService(WritableTenantEnvManager tenantEnvManager) {
        this.tenantEnvManager = tenantEnvManager;
    }

    public AbstractTimerCacheUpdateService(WritableTenantEnvManager tenantEnvManager, String tenantIdentifier, String schemaName) {
        this.tenantEnvManager = tenantEnvManager;
        this.schemaName = schemaName;
        this.tenantIdentifier = tenantIdentifier;
    }

    DataSource getAdminDataSource() {
        return MiddlewareDbManager.getAdminDataSource();
    }

    /*
     * Exception decompiling
     */
    Connection getConnection(DataSource dataSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp putApplicationsTocachebyGivenTime(Timestamp lastReloadedTime, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareException {
        LOGGER.debug((Object)"Storing application in database.");
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet rs = null;
        Timestamp latestLastReloadedTime = lastReloadedTime;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String appInfoTable = "app_info";
                String appContent = "app_content";
                String appContentType = "col1";
                String appVersion = "app_version";
                String appIdColumnName = "application_id";
                String appConfigRuntimeTable = "server_app_config";
                String configuration = "configuration";
                String updatedDate = "updated_date";
                String moduleName = "jar_module";
                StringBuilder query = new StringBuilder("select ");
                query.append("ai.").append(appContent).append(",").append("ai.").append(appContentType).append(",").append("ai.").append(appVersion).append(",").append("ai.").append(appIdColumnName).append(",").append("ai.").append(updatedDate).append(",").append("ac.").append(configuration).append(", ai.").append(moduleName).append(",ai.app_id").append(" from ").append(appInfoTable).append(" ai ").append(" left join " + appConfigRuntimeTable + " ac on ac.app_id=ai.app_id").append(" where ai.app_status in ('deployed','app_loading_inprogress') ");
                if (lastReloadedTime != null) {
                    query.append("  and ai.updated_date > ? ");
                }
                query.append(" order by ai.updated_date asc");
                prepareStatement = connection.prepareStatement(query.toString());
                if (lastReloadedTime != null) {
                    prepareStatement.setTimestamp(1, lastReloadedTime);
                }
                rs = prepareStatement.executeQuery();
                while (rs.next()) {
                    latestLastReloadedTime = this.populateAppCache(rs, dataAdapterCache);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection});
        return latestLastReloadedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerDataObject getAllServiceIdsBeforeGivenTimestamp(Timestamp lastUpdatedTime) throws SQLException, MiddlewareDbException {
        DataSource dataSource = this.getAdminDataSource();
        ArrayList<AppVersion> serviceIdList = new ArrayList<AppVersion>();
        HashMap<AppVersion, List<AssetType>> assetTypeListByAppVersion = new HashMap<AppVersion, List<AssetType>>();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet rs = null;
        Timestamp updatedDate = null;
        TimerDataObject dataObject = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String appInfoTable = "app_info";
                String appId = "application_id";
                String appVersionCol = "app_version";
                StringBuilder query = new StringBuilder("select ");
                query.append("ai.").append(appId).append(", ").append("ai.").append(appVersionCol).append(", ai.updated_date ").append(" from ").append(appInfoTable).append(" ai ").append(" where ai.app_status ='deployed' or ai.app_status ='app_loading_inprogress' and ai.updated_date < ?  order by ai.updated_date asc");
                prepareStatement = connection.prepareStatement(query.toString());
                prepareStatement.setTimestamp(1, lastUpdatedTime);
                rs = prepareStatement.executeQuery();
                while (rs.next()) {
                    AppVersion appVersion = new AppVersion(rs.getString(appId), rs.getString(appVersionCol));
                    updatedDate = rs.getTimestamp(3);
                    List<AssetType> assetTypeList = this.getAssetTypeListByTenantAppVersion(appVersion);
                    assetTypeListByAppVersion.put(appVersion, assetTypeList);
                    serviceIdList.add(appVersion);
                }
                dataObject = new TimerDataObject(null, serviceIdList, updatedDate, assetTypeListByAppVersion);
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection});
        return dataObject;
    }

    @Override
    public Timestamp copyJarsToFileSystem(Timestamp lastReloadedTime, String jarspath) throws IOException, MiddlewareDbException, SQLException {
        return null;
    }

    @Override
    public TimerDataObject getAllJarIds(Timestamp lastReloadedTime) throws SQLException, MiddlewareDbException {
        return null;
    }

    @Override
    public Timestamp loadAllAssetsFromDatabaseByAssetType(String assetType, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) throws SQLException, TenantException, MiddlewareDbException {
        return null;
    }

    @Override
    public Timestamp loadAllAppConfigFromDatabase(Timestamp lastReloadedTime) throws SQLException, TenantException, MiddlewareDbException {
        return null;
    }

    @Override
    public TimerDataObject reloadUpdateServicesAndRemoveDeletedServices(TimerDataObject timerDataObject, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareException {
        return null;
    }

    @Override
    public TimerDataObject reloadUpdatedJarsAndRemoveDeletedJars(List<String> loadedJarIds, Timestamp jarsLastUpdatedTimeStamp) throws SQLException, IOException, MiddlewareException {
        return null;
    }

    @Override
    public Timestamp populateAppCache(final ResultSet rs, final DataAdapterCache dataAdapterCache) throws TenantException {
        try {
            String version = rs.getString("app_version");
            String appId = rs.getString("application_id");
            Timestamp lastReloadedTime = rs.getTimestamp("updated_date");
            final AppVersion appVersion = new AppVersion(appId, version);
            final ModifiableAppCache appCache = this.getModifiableAppCacheFromTenantManager(this.tenantIdentifier);
            this.tenantEnvManager.loadIntoCache(this.tenantIdentifier, appVersion, new CacheUpdateHandler(){

                public void updateCache(String envGuid) throws TenantException, SQLException {
                    LOGGER.debug((Object)("Started updating the cache with AppVersion : " + appVersion));
                    AbstractTimerCacheUpdateService.this.decompressAndPutApplicationToCache(rs, appVersion, envGuid, appCache, dataAdapterCache);
                    LOGGER.debug((Object)("Finished updating the cache with AppVersion : " + appVersion));
                }

                public void doNotUpdate(String envGuid) {
                    if (appCache.getServiceVersionCache().contains(appVersion.getAppId())) {
                        try {
                            ApplicationInfo appInfo = AbstractTimerCacheUpdateService.this.getAppInfoFromResultSet(rs);
                            ApplicationHelper.buildAppMetadataFromAppInfo(appInfo, appVersion, appCache, envGuid);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)String.format("Exception occured while putting service %s into cache", appVersion.toString()), (Throwable)e);
                        }
                    }
                }
            });
            return lastReloadedTime;
        }
        catch (SQLException e) {
            throw new TenantException("tenant_db_connection_error", e.getMessage(), (Exception)e);
        }
    }

    public ApplicationMetadata decompressAndPutApplicationToCache(ResultSet rs, AppVersion appVersion, String envGuid, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) {
        LOGGER.debug((Object)("Started building app metadata with app version: " + appVersion));
        try {
            ApplicationInfo appInfo = this.getAppInfoFromResultSet(rs);
            return this.prepareApplicationMetadata(appVersion, envGuid, appCache, dataAdapterCache, appInfo);
        }
        catch (Exception e) {
            LOGGER.error((Object)String.format("Exception occured while putting service %s into cache", appVersion.toString()), (Throwable)e);
            return null;
        }
    }

    private ApplicationInfo getAppInfoFromResultSet(ResultSet rs) throws SQLException {
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.setAppContent(rs.getBlob("app_content"));
        appInfo.setContentType(rs.getString("col1"));
        appInfo.setAppID(rs.getInt("app_id"));
        appInfo.setLastReloadedTime(rs.getTimestamp("updated_date"));
        appInfo.setJarModuleName(rs.getString("jar_module"));
        return appInfo;
    }

    public ApplicationMetadata prepareApplicationMetadata(AppVersion appVersion, String envGuid, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache, ApplicationInfo appInfo) {
        ApplicationMetadata appMetadata = null;
        try {
            appMetadata = ApplicationHelper.buildAppMetadataFromAppInfo(appInfo, appVersion, appCache, envGuid);
            appCache.addAppMetadata(appVersion, appMetadata);
            appMetadata.setJarModuleName(appInfo.getJarModuleName());
            appCache.addProcessorMetadata(appVersion, ApplicationHelper.preparePrePostProcessorsMetadata(appMetadata, appInfo.getJarModuleName()));
            LOGGER.debug((Object)("Successfully loaded the app metadata into cache with app version" + appVersion));
            appCache.putTimestamp(appVersion, appInfo.getLastReloadedTime());
            this.loadAssetsByAppInfoPk(appCache, appVersion, appInfo.getAppID(), dataAdapterCache);
            dataAdapterCache.getUpdatedOrCreatedServices().add(appVersion);
        }
        catch (Exception e) {
            LOGGER.error((Object)"exception occured while preparing app metadata", (Throwable)e);
        }
        return appMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAssetsByAppInfoPk(ModifiableAppCache appCache, AppVersion tenantAppVersion, int appInfoPk, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareDbException {
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet resultSet = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String assetInfoTable = "asset_info";
                String appAssetInfoTable = "app_asset_info";
                String assetContent = "asset_content";
                String assetNameInDb = "asset_name";
                String assetTypeInDb = "asset_type";
                String contentTypeInDb = "col1";
                StringBuilder query = new StringBuilder("select ");
                query.append("asi." + contentTypeInDb).append(",");
                query.append("asi." + assetContent).append(",").append("asi." + assetNameInDb).append(",").append("asi." + assetTypeInDb).append(" from ").append(assetInfoTable).append(" asi inner join ").append(appAssetInfoTable).append(" aai on asi.asset_id = aai.asset_id ").append(" where aai.app_id =  ? ");
                prepareStatement = connection.prepareStatement(query.toString());
                prepareStatement.setInt(1, appInfoPk);
                resultSet = prepareStatement.executeQuery();
                appCache.getJavaScriptEngineWrapper().removeScriptsByNamespace(tenantAppVersion.toString());
                while (resultSet.next()) {
                    Blob assetBlob = resultSet.getBlob("asset_content");
                    String assetName = resultSet.getString(assetNameInDb);
                    String assetType = resultSet.getString(assetTypeInDb);
                    String contentType = resultSet.getString(contentTypeInDb);
                    this.loadAssetByContentAndName(assetBlob, assetName, assetType, tenantAppVersion, contentType, appCache, dataAdapterCache);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
    }

    public void loadAssetByContentAndName(Blob assetBlob, String assetName, String assetType, AppVersion appVersion, String contentType, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) throws SQLException {
        LOGGER.debug((Object)("Started loading asset :" + assetName));
        byte[] assetData = DBUtils.uncompressAndDecrypt((Blob)assetBlob, (String)contentType);
        AssetManager assetManager = AssetType.getAssetManager(assetType);
        if (assetManager.isLoadingSupported()) {
            assetManager.loadAsset(assetName, appVersion, assetData, appCache, dataAdapterCache);
        }
        LOGGER.debug((Object)("Done with loading asset : " + assetName));
    }

    protected void updateApplicationConfiguration(AppVersion appVersion, ResultSet resultSet) throws TenantException, SQLException {
        String configuration = resultSet.getString("configuration");
        Map<String, String> configMap = JsonUtil.jsonToMap(configuration);
        ApplicationMetadata appMetadata = (ApplicationMetadata)this.getModifiableAppCacheFromTenantManager(this.tenantIdentifier).getAppMetadata(appVersion);
        appMetadata.populateAppConfig(configMap);
    }

    protected void removeDeletedServices(TimerDataObject totalServicesinDb, TimerDataObject existingServiceAndAssets, DataAdapterCache dataAdapterCache) throws SQLException, TenantException, MiddlewareDbException {
        List<AppVersion> existingServices = existingServiceAndAssets.getServicesList();
        Map<AppVersion, List<AssetType>> assetTypeMap = existingServiceAndAssets.getAssetTypeMap();
        List<AppVersion> totalServicesInDb = totalServicesinDb.getServicesList();
        ModifiableAppCache konyAppCache = this.getModifiableAppCacheFromTenantManager(this.tenantIdentifier);
        if (existingServices != null && totalServicesInDb != null) {
            existingServices.removeAll(totalServicesInDb);
            if (!existingServices.isEmpty()) {
                for (AppVersion appVersion : existingServices) {
                    List<AssetType> assetTypeList;
                    if (appVersion == null || konyAppCache == null) continue;
                    new DataAdapterTask(konyAppCache, dataAdapterCache).destroyAdapterIfExists(appVersion);
                    konyAppCache.remove(appVersion);
                    if (assetTypeMap == null || (assetTypeList = assetTypeMap.get(appVersion)) == null) continue;
                    for (AssetType assetTypeEnum : assetTypeList) {
                        if (!assetTypeEnum.isShared() || assetTypeEnum.isDataAdapterType()) continue;
                        AssetType.getAssetManager(assetTypeEnum.getType()).clearAssetCache(konyAppCache, appVersion);
                        this.loadAllAssetsFromDatabaseByAssetType(assetTypeEnum.getType(), konyAppCache, dataAdapterCache);
                    }
                }
            }
        }
    }

    @Override
    public void deleteService(DataAdapterCache dataAdapterCache, ModifiableAppCache konyAppCache, AppVersion appVersion) throws SQLException, TenantException, MiddlewareDbException {
        List<AssetType> assetTypeList = this.getAssetTypeListByTenantAppVersion(appVersion);
        if (appVersion != null && konyAppCache != null) {
            new DataAdapterTask(konyAppCache, dataAdapterCache).destroyAdapterIfExists(appVersion);
            konyAppCache.removeProcessorMetadata(appVersion);
            konyAppCache.remove(appVersion);
            for (AssetType assetType : assetTypeList) {
                if (!assetType.isShared() || assetType.isDataAdapterType()) continue;
                AssetType.getAssetManager(assetType.getType()).clearAssetCache(konyAppCache, appVersion);
                this.loadAllAssetsFromDatabaseByAssetType(assetType.getType(), konyAppCache, dataAdapterCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AssetType> getAssetTypeListByTenantAppVersion(AppVersion appVersion) throws SQLException, MiddlewareDbException {
        ArrayList<AssetType> assetTypeList = new ArrayList<AssetType>();
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet resultSet = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String assetInfoTable = "asset_info";
                String appAssetInfo = "app_asset_info";
                String assetTypeInDb = "asset_type";
                StringBuilder query = new StringBuilder("select ");
                query.append("asi." + assetTypeInDb).append(" from ").append(assetInfoTable).append(" asi inner join ").append(appAssetInfo).append(" aai  on asi.asset_id = aai.asset_id ").append("where aai.app_id =  (select ai.app_id from app_info ai where ai.application_id = ? AND ai.app_version = ?) ");
                prepareStatement = connection.prepareStatement(query.toString());
                prepareStatement.setString(1, appVersion.getAppId());
                prepareStatement.setString(2, appVersion.getVersion());
                resultSet = prepareStatement.executeQuery();
                while (resultSet.next()) {
                    String assetType = resultSet.getString(assetTypeInDb);
                    AssetType assetTypeEnum = AssetType.getByType(assetType);
                    assetTypeList.add(assetTypeEnum);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
        return assetTypeList;
    }

    @Override
    public Timestamp reloadUpdatedConfigServiceParams(Timestamp lastUpdatedTimeStamp) throws SQLException, TenantException {
        LOGGER.debug((Object)"Reloading Config Service Params in timer..");
        HashMap configMap = new HashMap();
        HashMap currentPropNamesPerGroupMap = new HashMap();
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement newParamPrepareStatement = null;
        PreparedStatement propNamePrepareStatement = null;
        ResultSet newParamResultSet = null;
        ResultSet propNamesResultSet = null;
        String serverConfigGroupId = "SC";
        String clientConfigGroupId = "CC";
        Timestamp latestReloadedTime = null;
        ConfigurationProperties configProperties = this.getConfigServicesBean(this.tenantIdentifier);
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String userConfigTable = "USER_CONFIGURATION";
                String updatedDate = "updated_date";
                StringBuilder propNamesInDbQuery = new StringBuilder("select ").append("prop_name").append(", ").append("group_id").append(" from ").append(userConfigTable);
                StringBuilder newParamsQuery = new StringBuilder("select * from ").append(userConfigTable).append(" where ");
                if (lastUpdatedTimeStamp != null) {
                    newParamsQuery.append(updatedDate).append(" > ? ");
                }
                newParamsQuery.append(" order by ").append(updatedDate).append(" asc ");
                newParamPrepareStatement = connection.prepareStatement(newParamsQuery.toString());
                if (lastUpdatedTimeStamp != null) {
                    newParamPrepareStatement.setTimestamp(1, lastUpdatedTimeStamp);
                }
                newParamResultSet = newParamPrepareStatement.executeQuery();
                while (newParamResultSet.next()) {
                    String propName = newParamResultSet.getString("prop_name");
                    String propValue = newParamResultSet.getString("prop_value");
                    String group = newParamResultSet.getString("group_id");
                    LOGGER.debug((Object)("Found updated param : " + propName + " " + propValue + " " + group));
                    if (configMap.get(group) == null) {
                        configMap.put(group, new HashMap());
                    }
                    ((Map)configMap.get(group)).put(propName, propValue);
                    latestReloadedTime = newParamResultSet.getTimestamp(updatedDate);
                }
                propNamePrepareStatement = connection.prepareStatement(propNamesInDbQuery.toString());
                propNamesResultSet = propNamePrepareStatement.executeQuery();
                while (propNamesResultSet.next()) {
                    String group = propNamesResultSet.getString("group_id");
                    String prop_name = propNamesResultSet.getString("prop_name");
                    if (currentPropNamesPerGroupMap.get(group) == null) {
                        currentPropNamesPerGroupMap.put(group, new ArrayList());
                    }
                    ((List)currentPropNamesPerGroupMap.get(group)).add(prop_name);
                }
            }
            ConfigurationPropertiesManager.analyzeDbChangesAndUpdateConfigBean(configProperties, (Map)configMap.get("SC"), (List)currentPropNamesPerGroupMap.get("SC"), (Map)configMap.get("CC"), (List)currentPropNamesPerGroupMap.get("CC"));
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)"Exception in timer while reloading Config Services....");
                throw e;
            }
            catch (Throwable throwable) {
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{propNamesResultSet, newParamResultSet, propNamePrepareStatement, newParamPrepareStatement, connection});
                throw throwable;
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{propNamesResultSet, newParamResultSet, propNamePrepareStatement, newParamPrepareStatement, connection});
        return latestReloadedTime;
    }

    @Override
    public boolean isServerCertsUpdated(Timestamp prevTimestamp, int prevCount) throws SQLException {
        return ((ServerCertificateDAO)DAOFactory.getDAO(ServerCertificateDAO.class)).isServerCertsUpdated(prevTimestamp, prevCount);
    }

    @Override
    public Timestamp reloadHttpClientWithCerts() throws SQLException {
        ArrayList<ServerCertificate> allCerts = new ArrayList<ServerCertificate>();
        LOGGER.debug((Object)"Reading the certificates as changes are deteced in server_certificate");
        ((ServerCertificateDAO)DAOFactory.getDAO(ServerCertificateDAO.class)).consumeAllCerts(allCerts::add);
        ConnectorUtils.reinitializeWith(allCerts);
        return CollectionUtils.isNotEmpty(allCerts) ? ((ServerCertificate)allCerts.get(allCerts.size() - 1)).getUpdatedTimestamp() : new Timestamp(-1L);
    }

    private ConfigurationProperties getConfigServicesBean(String tenantIdentifier) throws TenantException {
        return this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(tenantIdentifier).getConfigurationProperties();
    }

    protected ModifiableAppCache getModifiableAppCacheFromTenantManager(String tenantIdentifier) throws TenantException {
        return (ModifiableAppCache)this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(tenantIdentifier).getAppCache();
    }

    @Override
    public void reloadJars() throws MiddlewareDbException, IOException, SQLException, MiddlewareException {
    }

    @Override
    public void deleteServices(TimerNotification timerNotification, String singleTenantIdentifier, DataAdapterCache dataAdapterCache) throws TenantException, SQLException {
    }

    @Override
    public void loadServices(TimerNotification timerNotification, DataAdapterCache dataAdapterCache, Timestamp lastUpdatedTime) throws SQLException, Exception {
    }

    @Override
    public void loadAllServices(DataAdapterCache dataAdapterCache) throws MiddlewareException, SQLException {
    }
}

