/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.service;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.ServicesInfoDAO;
import com.kony.middleware.dbcommons.entity.TimerNotification;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.ClassLoaderProperties;
import com.konylabs.middleware.classloader.MiddlewareClassloader;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWConsumer;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.objservices.metadata.MetadataUtils;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.service.AbstractTimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.TimerDataObject;
import com.konylabs.middleware.timer.TimerUtils;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DbTimerCacheUpdateServiceImpl
extends AbstractTimerCacheUpdateService {
    private static final Logger LOGGER = Logger.getLogger(DbTimerCacheUpdateServiceImpl.class);
    private ServicesInfoDAO servicesInfoDAO = (ServicesInfoDAO)DAOFactory.getDAO(ServicesInfoDAO.class);

    public DbTimerCacheUpdateServiceImpl(WritableTenantEnvManager tenantEnvManager) {
        super(tenantEnvManager);
    }

    public DbTimerCacheUpdateServiceImpl(WritableTenantEnvManager tenantEnvManager, String tenantIdentifier) {
        super(tenantEnvManager, tenantIdentifier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAppDiffoInfo(Timestamp startReloadTime, Timestamp lastReloadedTime) throws TenantException, MiddlewareDbException, SQLException {
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement appDiffPreparedStatement = null;
        ResultSet appDiffResultSet = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                StringBuilder appDiffQuery = new StringBuilder("select ");
                appDiffQuery.append("adi.*, ");
                appDiffQuery.append("ai.").append("application_id");
                appDiffQuery.append(", ai.app_version");
                appDiffQuery.append(" from ").append("server_app_diff_info").append(" adi, ");
                appDiffQuery.append("app_info").append(" ai");
                appDiffQuery.append(" where adi.app_id=ai.app_id");
                appDiffQuery.append(" and adi.updated_date > ? ");
                appDiffQuery.append(" and adi.updated_date <= ? ");
                appDiffQuery.append(" order by adi.updated_date asc");
                appDiffPreparedStatement = connection.prepareStatement(appDiffQuery.toString());
                appDiffPreparedStatement.setTimestamp(1, startReloadTime);
                appDiffPreparedStatement.setTimestamp(2, lastReloadedTime);
                appDiffResultSet = appDiffPreparedStatement.executeQuery();
                ModifiableAppCache appCahce = (ModifiableAppCache)this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(this.tenantIdentifier).getAppCache();
                while (appDiffResultSet.next()) {
                    String applicationId = appDiffResultSet.getString("application_id");
                    String applicationVersion = appDiffResultSet.getString("app_version");
                    Blob publishedAppDiffBlob = appDiffResultSet.getBlob("app_diff_object");
                    Timestamp createdTimestamp = new Timestamp(MetadataUtils.getTimeTillSeconds(appDiffResultSet.getTimestamp("created_date")));
                    Timestamp updatedTimestamp = new Timestamp(MetadataUtils.getTimeTillSeconds(appDiffResultSet.getTimestamp("updated_date")));
                    String metadataResponse = MetadataUtils.getMetadataFromAppDiffBean(publishedAppDiffBlob, updatedTimestamp);
                    appCahce.putAppDiffResult(new AppVersion(applicationId, applicationVersion), createdTimestamp, metadataResponse);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{appDiffResultSet, appDiffPreparedStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{appDiffResultSet, appDiffPreparedStatement, connection});
    }

    @Override
    public TimerDataObject reloadUpdateServicesAndRemoveDeletedServices(TimerDataObject existingServiceAndAssets, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareException {
        Timestamp servicesLastUpdatedTimeStamp = existingServiceAndAssets.getDate();
        Timestamp lastUpdatedTime = this.putApplicationsTocachebyGivenTime(servicesLastUpdatedTimeStamp, dataAdapterCache);
        this.calculateAppDiffoInfo(servicesLastUpdatedTimeStamp, lastUpdatedTime);
        TimerDataObject totalServicesinDb = this.getAllServiceIdsBeforeGivenTimestamp(lastUpdatedTime);
        this.removeDeletedServices(totalServicesinDb, existingServiceAndAssets, dataAdapterCache);
        return new TimerDataObject(null, totalServicesinDb.getServicesList(), lastUpdatedTime, totalServicesinDb.getAssetTypeMap());
    }

    public Timestamp copyJarsToFileSystem(String jarsPath) throws IOException, MiddlewareDbException, SQLException {
        return this.copyJarsToFileSystem(null, jarsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp copyJarsToFileSystem(Timestamp lastReloadedTime, String jarsPath) throws IOException, MiddlewareDbException, SQLException {
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        Statement statement = null;
        ResultSet rs = null;
        Timestamp updatedDate = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                statement = connection.createStatement();
                String jarInfoTable = "server_jar_info";
                String jarContent = "jar_content";
                String jarNameInDb = "jar_name";
                String moduleName = "jar_module";
                StringBuilder query = new StringBuilder("select ");
                query.append(jarContent).append(",").append(jarNameInDb).append(",").append(moduleName).append(" , updated_date from ").append(jarInfoTable);
                if (lastReloadedTime != null) {
                    query.append(" where updated_date > ? ");
                }
                query.append(" order by updated_date asc");
                if (lastReloadedTime != null) {
                    prepareStatement = connection.prepareStatement(query.toString());
                    prepareStatement.setTimestamp(1, lastReloadedTime);
                    rs = prepareStatement.executeQuery();
                } else {
                    rs = statement.executeQuery(query.toString());
                }
                while (rs.next()) {
                    Blob jarBlob = rs.getBlob("jar_content");
                    String jarName = rs.getString(jarNameInDb);
                    String jarModuleName = StringUtils.isNotBlank((String)rs.getString(moduleName)) ? rs.getString(moduleName) : ClassLoaderProperties.DEFAULT_MODULE_NAME.getName();
                    LOGGER.debug((Object)("Found jar " + jarName + " with module " + jarModuleName + " in DB"));
                    updatedDate = rs.getTimestamp("updated_date");
                    TimerUtils.copyBlobToFile(jarBlob, jarsPath.concat(jarModuleName).concat("/"), jarName);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection, statement});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection, statement});
        return updatedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp loadAllAssetsFromDatabaseByAssetType(String assetType, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareDbException {
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet resultSet = null;
        Timestamp updatedDate = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String assetInfoTable = "asset_info";
                String appInfoTable = "app_info";
                String app_asset_info = "app_asset_info";
                String assetContent = "asset_content";
                String assetNameInDb = "asset_name";
                String assetTypeInDb = "asset_type";
                String contentTypeInDb = "col1";
                String updated_date = "updated_date";
                String application_id = "application_id";
                String appVersion = "app_version";
                StringBuilder query = new StringBuilder("select ");
                query.append("ai." + application_id).append(",").append("ai." + appVersion).append(",");
                query.append("asi." + contentTypeInDb).append(",");
                query.append("asi." + assetContent).append(",").append("asi." + assetNameInDb).append(",").append("asi." + assetTypeInDb).append(" ,").append("asi." + updated_date).append(" from ").append(app_asset_info).append(" aai").append(",").append(appInfoTable).append(" ai ").append(",").append(assetInfoTable).append(" asi ");
                query.append(" where aai.app_id = ai.app_id and aai.asset_id = asi.asset_id ");
                query.append("  and asi.").append(assetTypeInDb).append(" = ? ");
                query.append(" order by updated_date asc");
                prepareStatement = connection.prepareStatement(query.toString());
                prepareStatement.setString(1, assetType);
                resultSet = prepareStatement.executeQuery();
                while (resultSet.next()) {
                    Blob assetBlob = resultSet.getBlob("asset_content");
                    String assetName = resultSet.getString(assetNameInDb);
                    String contentType = resultSet.getString(contentTypeInDb);
                    updatedDate = resultSet.getTimestamp("updated_date");
                    AppVersion tenantAppVersion = new AppVersion(resultSet.getString("application_id"), resultSet.getString("app_version"));
                    this.loadAssetByContentAndName(assetBlob, assetName, assetType, tenantAppVersion, contentType, appCache, dataAdapterCache);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
        return updatedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp loadAllAppConfigFromDatabase(Timestamp lastReloadedTime) throws SQLException, TenantException, MiddlewareDbException {
        DataSource dataSource = this.getAdminDataSource();
        Connection connection = null;
        PreparedStatement prepareStatement = null;
        ResultSet resultSet = null;
        Timestamp latestReloadedTime = null;
        try {
            if (dataSource != null && (connection = this.getConnection(dataSource)) != null) {
                String appInfoTable = "app_info";
                String appConfigTable = "server_app_config";
                String configuration = "configuration";
                String updatedDate = "updated_date";
                String applicationId = "application_id";
                String appVersion = "app_version";
                StringBuilder query = new StringBuilder("select ");
                query.append("ai." + applicationId).append(",").append("ai." + appVersion).append(",");
                query.append("ac." + configuration).append(",").append("ac." + updatedDate).append(" from ").append(appInfoTable).append(" ai").append(",").append(appConfigTable).append(" ac ");
                query.append(" where ai.app_status in ('deployed','app_loading_inprogress') and ai.app_id = ac.app_id ");
                if (lastReloadedTime != null) {
                    query.append("  and ac.updated_date > ? ");
                }
                query.append(" order by ac.updated_date asc");
                prepareStatement = connection.prepareStatement(query.toString());
                if (lastReloadedTime != null) {
                    prepareStatement.setTimestamp(1, lastReloadedTime);
                }
                resultSet = prepareStatement.executeQuery();
                while (resultSet.next()) {
                    latestReloadedTime = resultSet.getTimestamp(updatedDate);
                    AppVersion tenantAppVersion = new AppVersion(resultSet.getString(applicationId), resultSet.getString(appVersion));
                    this.updateApplicationConfiguration(tenantAppVersion, resultSet);
                }
            }
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
            throw throwable;
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{resultSet, prepareStatement, connection});
        return latestReloadedTime;
    }

    @Override
    public void reloadJars() throws IOException, SQLException, MiddlewareException {
        MiddlewareClassloaderManager classLoaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
        Map<String, Object> existingClassLoaderResources = ((MiddlewareClassloader)classLoaderManager.getMiddlewareLibClassLoader()).getResources();
        classLoaderManager.refresh();
        this.copyJarsToFileSystem(classLoaderManager.getDefaultJarLocation());
        classLoaderManager.load();
        ((MiddlewareClassloader)classLoaderManager.getMiddlewareLibClassLoader()).addResources(existingClassLoaderResources);
    }

    @Override
    public void loadAllServices(DataAdapterCache dataAdapterCache) throws MiddlewareException, SQLException {
        this.loadServices(null, dataAdapterCache, null);
    }

    @Override
    public void loadServices(TimerNotification timerNotification, DataAdapterCache dataAdapterCache, Timestamp lastReloadedUpdatedTime) throws MiddlewareException, SQLException {
        MWConsumer servicesLoader = rs -> this.populateAppCache((ResultSet)rs, dataAdapterCache);
        this.servicesInfoDAO.getServicesWithProcessId(timerNotification != null ? Long.valueOf(timerNotification.getProcessId()) : null, servicesLoader);
        this.calculateAppDiffoInfo(lastReloadedUpdatedTime, timerNotification != null ? timerNotification.getUpdatedDate() : null);
    }

    @Override
    public void deleteServices(TimerNotification timerNotification, String singleTenantIdentifier, DataAdapterCache dataAdapterCache) throws TenantException, SQLException {
        ModifiableAppCache appCache = this.getModifiableAppCacheFromTenantManager(singleTenantIdentifier);
        Consumer<AppVersion> serviceRemover = appVersion -> {
            try {
                LOGGER.debug((Object)("Deleting Service " + appVersion + " from cache"));
                this.deleteService(dataAdapterCache, appCache, (AppVersion)appVersion);
            }
            catch (TenantException | MiddlewareDbException | SQLException e) {
                LOGGER.error((Object)"Failed to delete service ", e);
            }
        };
        this.servicesInfoDAO.getDeletedServiceFromProcessId(timerNotification.getProcessId(), serviceRemover);
    }
}

