/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.service;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.ApplicationInfoDAO;
import com.kony.middleware.dbcommons.dao.EnvironmentDetailsDAO;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.ApplicationInfo;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.service.EnvironmentService;
import com.konylabs.middleware.service.MultiTimerCacheUpdateService;
import com.konylabs.middleware.tenant.impl.MultiTenantAppCache;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EnvironmentServiceImpl
implements EnvironmentService {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentServiceImpl.class);

    @Override
    public ApplicationMetadata fetchAppMetadataFromDatabase(AppVersion appVersion, String schemaName, String envGuid, MultiTenantAppCache multiTenantAppCache) throws AppRegistryException {
        Object connection = null;
        Object prepareStatement = null;
        Object createStatement = null;
        Object rs = null;
        ApplicationMetadata appMetadata = null;
        DataAdapterCache dataAdapterCache = null;
        MultiTimerCacheUpdateService timerCacheUpdateService = new MultiTimerCacheUpdateService(schemaName);
        try {
            ApplicationInfo applicationInfo = ((ApplicationInfoDAO)DAOFactory.getDAO(ApplicationInfoDAO.class)).getAppInfo(appVersion, schemaName, envGuid);
            dataAdapterCache = new DataAdapterCache();
            if (applicationInfo != null) {
                appMetadata = timerCacheUpdateService.prepareApplicationMetadata(appVersion, envGuid, multiTenantAppCache, dataAdapterCache, applicationInfo);
            }
            multiTenantAppCache.getFrontendResourceIdentifier().getResourceIdentifierBuilder().build();
            DataAdapterUtil.performAdapterIntialization(multiTenantAppCache, dataAdapterCache);
        }
        catch (SQLException se) {
            try {
                LOGGER.error((Object)("Error while fetching app metadata with app version : " + appVersion), (Throwable)se);
                String errorCode = "10107";
                String errorMessage = AppRegistryException.getErrorMessageForKey((String)"no_app_exists_withid_version");
                throw new AppRegistryException(errorCode, errorMessage);
            }
            catch (Throwable throwable) {
                Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection, createStatement});
                throw throwable;
            }
        }
        Closer.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{rs, prepareStatement, connection, createStatement});
        return appMetadata;
    }

    @Override
    public Map<String, String> getEnvironmentDetails() throws TenantException {
        return TenantUtilities.isMultiTenant() ? new HashMap() : this.getEnvironmentDetails(null);
    }

    @Override
    public Map<String, String> getEnvironmentDetails(String tenantIdentifier) throws TenantException {
        Map<String, String> envConfigProps = TenantUtilities.loadTenantEnvLevelProperties();
        BiConsumer<String, String> propsUpdater = (key, value) -> {
            if (value != null) {
                envConfigProps.put((String)key, (String)value);
            }
        };
        try {
            ((EnvironmentDetailsDAO)DAOFactory.getDAO(EnvironmentDetailsDAO.class)).getEnvironmentDetails(tenantIdentifier, propsUpdater);
            String schemaName = envConfigProps.get("schema_name");
            if (StringUtils.isNotBlank((String)tenantIdentifier) && StringUtils.isNotBlank((String)schemaName)) {
                ((EnvironmentDetailsDAO)DAOFactory.getDAO(EnvironmentDetailsDAO.class)).getTenantSpecificConfigurationProperties(tenantIdentifier, schemaName, propsUpdater);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Exception while fetching the environment details of tenant : " + tenantIdentifier), (Throwable)e);
        }
        return envConfigProps;
    }
}

