/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.service;

import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.service.AbstractTimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.TimerDataObject;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class MultiTimerCacheUpdateService
extends AbstractTimerCacheUpdateService {
    private static final Logger LOGGER = Logger.getLogger(MultiTimerCacheUpdateService.class);

    public MultiTimerCacheUpdateService(String schemaName) {
        super(schemaName);
    }

    public MultiTimerCacheUpdateService(WritableTenantEnvManager tenantEnvManager, String tenantIdentifier, String schemaName) {
        super(tenantEnvManager, tenantIdentifier, schemaName);
    }

    @Override
    public TimerDataObject reloadUpdateServicesAndRemoveDeletedServices(TimerDataObject existingServiceAndAssets, DataAdapterCache dataAdapterCache) throws SQLException, MiddlewareException {
        LOGGER.debug((Object)String.format("Updating services and removing deleted services for tenant : %s", this.tenantIdentifier));
        Timestamp servicesLastUpdatedTimeStamp = existingServiceAndAssets.getDate();
        Timestamp lastUpdatedTime = this.putApplicationsTocachebyGivenTime(servicesLastUpdatedTimeStamp, dataAdapterCache);
        TimerDataObject totalServicesinDb = this.getAllServiceIdsBeforeGivenTimestamp(lastUpdatedTime);
        this.removeDeletedServices(totalServicesinDb, existingServiceAndAssets, dataAdapterCache);
        return new TimerDataObject(null, totalServicesinDb.getServicesList(), lastUpdatedTime, totalServicesinDb.getAssetTypeMap());
    }

    @Override
    public Timestamp reloadUpdatedConfigServiceParams(Timestamp lastUpdatedTimeStamp) throws SQLException, TenantException {
        return null;
    }
}

