/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.services;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.connectors.AsyncConnector;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.exceptions.ProcessorInitializationException;
import com.konylabs.middleware.processor.Configuration;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.KonyAppCache;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractServiceDelegate
implements Processor {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceDelegate.class);
    protected HashMap<String, Connector> connectors_ = new HashMap();
    protected HashMap<String, AsyncConnector> asyncConnectors_ = new HashMap();
    protected boolean initialized_ = false;
    protected String processorName_ = null;
    protected Configuration config_ = null;

    public void initConfig(String processorName, Configuration config) throws ProcessorInitializationException {
        if (this.initialized_) {
            return;
        }
        this.processorName_ = processorName;
        this.config_ = config;
        this.initialized_ = true;
    }

    public void execute(DataControllerRequest request, DataControllerResponse response) throws ProcessorException {
        if (request.getAttribute("appregistry_Cache") == null) {
            request.setAttribute("appregistry_Cache", (Object)KonyAppCache.getInstance());
        }
        Service service = this.validateRequestAndLookupService(request);
        this.invokeService(service, request, response);
    }

    protected Service validateRequestAndLookupService(DataControllerRequest request) throws ProcessorException {
        LOGGER.debug((Object)("Processor Name: " + this.processorName_));
        String serviceID = request.getParameter("serviceID");
        String appID = request.getParameter("appID");
        String objectId = request.getParameter("objectID");
        String apiVersion = request.getHeader("X-Kony-API-Version");
        MetricsUtils.addParamToMetricsBean(request, "rver", apiVersion);
        AppCache appCache = (AppCache)request.getAttribute("appregistry_Cache");
        if (StringUtils.isBlank((String)apiVersion)) {
            apiVersion = MiddlewareUtils.getRuntimeVersion(appCache, appID);
        }
        MetricsUtils.addParamToMetricsBean(request, "svcver", apiVersion);
        LOGGER.debug((Object)("Service ID: " + serviceID + ", App ID: " + appID));
        if (StringUtils.isBlank((String)appID)) {
            LOGGER.error((Object)"appID is empty. Please provide the appID");
            throw new ProcessorException(this.processorName_, "10101", "Please provide the appID");
        }
        if (StringUtils.isBlank((String)serviceID)) {
            LOGGER.error((Object)"ServiceID is empty. Please provide the serviceID");
            throw new ProcessorException(this.processorName_, "10102", "Please provide the serviceID");
        }
        ApplicationMetadata appMetadata = (ApplicationMetadata)appCache.getAppMetadata(new AppVersion(appID, apiVersion));
        ServiceMetadata serviceMetadata = appMetadata.getServiceMetadata(serviceID);
        Service service = serviceMetadata.getService();
        if (StringUtils.isNotBlank((String)objectId)) {
            serviceMetadata.setObjectId(objectId);
        }
        return service;
    }

    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ProcessorException {
        this.invokeService(service, request, response);
        return (Result)request.getAttribute("results");
    }

    public abstract void invokeService(Service var1, DataControllerRequest var2, DataControllerResponse var3) throws ProcessorException;

    public abstract Connector getConnector(String var1) throws ProcessorException;
}

