/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.services;

import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.config.Context;
import com.konylabs.middleware.config.DatasourcePayloadLogger;
import com.konylabs.middleware.config.Observer;
import com.konylabs.middleware.config.TraceLogProperties;
import com.konylabs.middleware.connectors.AsyncConnector;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.WrapperAsyncConnector;
import com.konylabs.middleware.controller.AsyncHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.datasourcelogs.LogDataSourceData;
import com.konylabs.middleware.datasourcelogs.ServiceExecutionObserver;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ConnectorInitializationException;
import com.konylabs.middleware.exceptions.MBaaSException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.factory.KonyAppFactory;
import com.konylabs.middleware.jmx.mbeans.ActiveServiceCount;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.processor.AsyncProcessor;
import com.konylabs.middleware.processor.Attribute;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.AbstractServiceDelegate;
import com.konylabs.middleware.services.ServiceDelegateAsyncHandler;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServiceDelegate
extends AbstractServiceDelegate
implements AsyncProcessor,
Observer {
    private static final Logger LOGGER = Logger.getLogger(ServiceDelegate.class);
    private static final ServiceDelegateAsyncHandler serviceDelegateAsyncHandler = new ServiceDelegateAsyncHandler();

    @Override
    public void invokeService(Service service, DataControllerRequest request, DataControllerResponse response) throws ProcessorException {
        String serviceType = service.getServiceType();
        Connector connector = this.getConnector(serviceType);
        Result res = null;
        String svcID = service.getId();
        ActiveServiceCount actSvcCount = null;
        try {
            connector.setCallingProcessor(this);
            if (ConfigUtility.getBoolean((String)"mbeans.instantiation", (boolean)false)) {
                actSvcCount = new ActiveServiceCount(svcID);
            }
            service = MiddlewareMBaasUtils.validateIdentityProviderChanges(service, request.getHeaderMap(), request);
            res = connector.execute(service, request, response);
        }
        catch (MBaaSException ce) {
            MaskUtils.maskTrace((String)(ce.getMessage() + " for service " + svcID), (Throwable)ce);
            throw new ProcessorException(this.processorName_, ce.getErrorCode(), ce.getHttpStatusCode(), ce.getMessage(), (Exception)((Object)ce));
        }
        catch (ConnectorInitializationException ce) {
            MaskUtils.maskTrace((String)(ce.getMessage() + " for service " + svcID), (Throwable)ce);
            throw new ProcessorException(this.processorName_, ce.getErrorCode(), ce.getMessage(), (Exception)((Object)ce));
        }
        catch (ConnectorException ce) {
            MaskUtils.maskTrace((String)(ce.getMessage() + " for service " + svcID), (Throwable)ce);
            throw new ProcessorException(this.processorName_, ce.getErrorCode(), ce.getHttpStatusCode(), ce.getMessage(), (Exception)((Object)ce));
        }
        finally {
            if (ConfigUtility.getBoolean((String)"mbeans.instantiation", (boolean)false) && actSvcCount != null) {
                actSvcCount.decrementServiceCount(svcID);
            }
        }
        this.handleResult(service, request, res, svcID);
    }

    private void invokeServiceAsyncContext(Service service, DataControllerRequest request, DataControllerResponse response, Context parentContext) {
        String serviceType = service.getServiceType();
        com.kony.adapter.model.Context context = new com.kony.adapter.model.Context();
        AsyncHandler parentAsyncHandler = (AsyncHandler)parentContext.get("handler");
        try {
            AsyncConnector connector = this.getAsyncConnector(serviceType);
            connector.setServiceDelegate(this);
            Service changedService = MiddlewareMBaasUtils.validateIdentityProviderChanges(service, request.getHeaderMap(), request);
            ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(changedService);
            context.put("parentContext", (Object)parentContext);
            context.put("serviceDelegate", (Object)this);
            context.put("serviceMetadata", (Object)serviceMetadata);
            context.put("request", (Object)request);
            context.put("response", (Object)response);
            context.put("handler", (Object)serviceDelegateAsyncHandler);
            connector.executeAsync(serviceMetadata, request, response, context, MiddlewareUtils.populateConfigMap(serviceMetadata.getService(), serviceMetadata));
        }
        catch (MBaaSException exception) {
            parentAsyncHandler.onError(request, response, (MiddlewareException)((Object)new ProcessorException(this.processorName_, exception.getErrorCode(), exception.getHttpStatusCode(), exception.getMessage(), (Exception)((Object)exception))), parentContext);
        }
        catch (ProcessorException exception) {
            parentAsyncHandler.onError(request, response, (MiddlewareException)((Object)exception), parentContext);
        }
    }

    public void execute(DataControllerRequest request, DataControllerResponse response, Context parentContext) {
        try {
            Service service = this.validateRequestAndLookupService(request);
            this.invokeServiceAsyncContext(service, request, response, parentContext);
        }
        catch (ProcessorException e) {
            ((AsyncHandler)parentContext.get("handler")).onError(request, response, (MiddlewareException)((Object)e), parentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResult(Service service, DataControllerRequest request, Result res, String svcID) throws ProcessorException {
        if (res == null) {
            LOGGER.error((Object)("Results fetched by connector is null for service " + svcID));
            throw new ProcessorException(this.processorName_, "10106", "Results fetched by connector is null for service " + svcID);
        }
        request.setAttribute("results", (Object)res);
        Session session = request.getSession(false);
        if (EnvironmentFactory.getEnvironment() != null && CacheUtils.isSesionDistributed().booleanValue() && session != null) {
            LOGGER.debug((Object)"Session is distributed");
            if ("rc".equals(request.getParameter("channel")) && ("logout".equalsIgnoreCase(svcID) || "signoff".equalsIgnoreCase(svcID))) {
                LOGGER.debug((Object)("ServiceID: " + svcID + " invalidating the session"));
                session.invalidate();
                LOGGER.debug((Object)"Successfuully invalidating the session");
            } else {
                String sessionId;
                HttpServletRequest originalRequest = (HttpServletRequest)request.getOriginalRequest();
                String string = sessionId = originalRequest != null ? (String)originalRequest.getAttribute("SESSIONID") : null;
                if (sessionId != null && !session.getId().equals(sessionId)) {
                    LOGGER.debug((Object)"Session has been re-created, regenerating the cache-id");
                    if (originalRequest != null) {
                        try {
                            HttpServletRequest httpServletRequest = originalRequest;
                            synchronized (httpServletRequest) {
                                KonyAppFactory.getSessionManagerInstance().recreateCache(originalRequest);
                                originalRequest.setAttribute("SESSIONID", (Object)session.getId());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error while re-creating the cache of service " + svcID));
                        }
                    }
                }
                if (originalRequest != null) {
                    boolean isCookieSupported;
                    Object obj = originalRequest.getAttribute("cacheid");
                    MaskUtils.logDebugWithMasking((String)"Cache ID Provided by the invoking client", (String)"cacheid", (String)String.valueOf(obj));
                    boolean bl = isCookieSupported = originalRequest.getAttribute("isCookieSupported") != null && Boolean.valueOf((Boolean)originalRequest.getAttribute("isCookieSupported")) != false;
                    if (!isCookieSupported && obj != null) {
                        res.addParam(new com.konylabs.middleware.dataobject.Param("cacheid", (String)obj, "string"));
                    }
                }
            }
        }
        if (!MiddlewareUtils.isResponsePassThrough(service)) {
            int i;
            ArrayList osparams = service.getServiceOutput().getParams();
            ArrayList<com.konylabs.middleware.dataobject.Param> removeList = new ArrayList<com.konylabs.middleware.dataobject.Param>();
            for (i = 0; i < osparams.size(); ++i) {
                Param param = (Param)osparams.get(i);
                String name = param.getName();
                String target = param.getTarget();
                if (!"session".equals(target)) continue;
                if (session == null) {
                    LOGGER.error((Object)("Error 6000: Session deosn't exist where as source is mentioned as session for the param " + target));
                    throw new ProcessorException(service.getServiceType(), "6000", "Session deosnt exist where as source is mentioned as session for service " + svcID);
                }
                for (com.konylabs.middleware.dataobject.Param pr : res.getAllParams()) {
                    if (pr == null || !name.equals(pr.getName())) continue;
                    MaskUtils.logDebugWithMasking((String)"Setting the session attribute", (String)pr.getName(), (String)pr.getValue());
                    session.setAttribute(pr.getName(), (Object)pr.getValue());
                    removeList.add(pr);
                }
            }
            if (!removeList.isEmpty()) {
                LOGGER.debug((Object)"Removing the parameters which are part of the session from the result object and retaining them in session");
                for (i = 0; i < removeList.size(); ++i) {
                    res.removeParam((com.konylabs.middleware.dataobject.Param)removeList.get(i));
                }
            }
            String resString = null;
            if (DatasourcePayloadLogger.isEnabled() || LOGGER.isDebugEnabled()) {
                try {
                    resString = ResultToJSON.debugConvert((Result)res);
                    LOGGER.debug((Object)("Service response : " + resString));
                    DatasourcePayloadLogger.log("Datasource Payload response for Service : %s", service.getId());
                    DatasourcePayloadLogger.log("Datasource Payload response : %s", resString);
                }
                catch (Exception je) {
                    LOGGER.debug((Object)"Error in Result Object Conversion to Json : ", (Throwable)je);
                }
            }
        }
    }

    @Override
    public Connector getConnector(String serviceType) throws ProcessorException {
        this.loadConnector(serviceType);
        return (Connector)this.connectors_.get(serviceType);
    }

    public AsyncConnector getAsyncConnector(String serviceType) throws ProcessorException {
        this.loadConnector(serviceType);
        return (AsyncConnector)this.asyncConnectors_.get(serviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConnector(String serviceType) throws ProcessorException {
        HashMap hashMap = this.connectors_;
        synchronized (hashMap) {
            Connector connector = (Connector)this.connectors_.get(serviceType);
            if (connector == null) {
                Attribute attr = this.config_.getParameter(serviceType);
                Attribute asyncAttr = this.config_.getParameter("async-" + serviceType);
                if (attr != null) {
                    AsyncConnector asyncConnector;
                    String className = (String)attr.value_;
                    String asyncClassName = asyncAttr != null ? (String)asyncAttr.value_ : null;
                    try {
                        connector = (Connector)MiddlewareClassloaderFactory.getClassLoaderManager().getInstance(className);
                        AsyncConnector asyncConnector2 = asyncConnector = asyncClassName != null ? (AsyncConnector)MiddlewareClassloaderFactory.getClassLoaderManager().getInstance(asyncClassName) : new WrapperAsyncConnector(connector);
                        if (LogDataSourceData.isTraceEnabled()) {
                            this.doServiceExecutionObserverRegister(connector);
                            this.doServiceExecutionObserverRegister(asyncConnector);
                        }
                    }
                    catch (MiddlewareException ex) {
                        LOGGER.error((Object)("Error MW10105: Error in Instantiating the connector class for service type " + serviceType));
                        throw new ProcessorException(this.processorName_, "10105", "Error in Instantiating the connector class");
                    }
                    catch (Error ex) {
                        LOGGER.error((Object)("Error MW10104: Error in Loading / Instantiating the connector class for service type " + serviceType), (Throwable)ex);
                        throw new ProcessorException(this.processorName_, "10104", "Error in Loading / Instantiating the connector class for service type");
                    }
                    if (connector == null) {
                        LOGGER.error((Object)("Error MW10104 Error in loading the connector class for service type " + serviceType));
                        throw new ProcessorException(this.processorName_, "10104", "Error in loading the connector class");
                    }
                    this.connectors_.put(serviceType, connector);
                    this.asyncConnectors_.put(serviceType, asyncConnector);
                } else {
                    LOGGER.error((Object)("Error: serviceType configuration " + serviceType + " is missing or wrong"));
                    throw new ProcessorException(this.processorName_, "10103", "Error: serviceType configuration is missing or wrong. Please look at possible serviceTypes");
                }
            }
        }
    }

    private void doServiceExecutionObserverRegister(Object connector) {
        if (connector instanceof DataAdapterEventNotifier) {
            ((DataAdapterEventNotifier)connector).register((DataAdapterEventObserver)new ServiceExecutionObserver());
            LOGGER.trace((Object)"added ServiceExecutionObserver for logs");
        }
    }

    private void doServiceExecutionObserverUnRegister(Object connector) {
        if (connector instanceof DataAdapterEventNotifier) {
            ((DataAdapterEventNotifier)connector).unregister((DataAdapterEventObserver)new ServiceExecutionObserver());
            LOGGER.trace((Object)"added ServiceExecutionObserver for logs");
        }
    }

    public void updateConfiguration(Map<String, Object> updatedMap) {
        block6: {
            if (!updatedMap.containsKey(TraceLogProperties.LEVEL.getName())) break block6;
            String traceLogLevel = (String)updatedMap.get(TraceLogProperties.LEVEL.getName());
            if ("ON".equalsIgnoreCase(traceLogLevel)) {
                for (Object connector : this.connectors_.values()) {
                    this.doServiceExecutionObserverRegister(connector);
                }
                for (Object connector : this.asyncConnectors_.values()) {
                    this.doServiceExecutionObserverRegister(connector);
                }
            } else {
                for (Object connector : this.connectors_.values()) {
                    this.doServiceExecutionObserverUnRegister(connector);
                }
                for (Object connector : this.asyncConnectors_.values()) {
                    this.doServiceExecutionObserverUnRegister(connector);
                }
            }
        }
    }
}

