/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.servlet;

import com.konylabs.middleware.classloader.MiddlewareClassloaderEvent;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderObserver;
import com.konylabs.middleware.servlet.utils.AnnotationParsingUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import org.apache.log4j.Logger;

public class KonyCompositeServletManager
implements MiddlewareClassloaderObserver {
    private Map<Servlet, String[]> servletmap = new HashMap<Servlet, String[]>();
    private Map<String, Servlet> servletByRequestPath = new HashMap<String, Servlet>();
    private ServletConfig servletConfig;
    private static KonyCompositeServletManager instance;
    private static final Logger LOGGER;

    private KonyCompositeServletManager(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        this.loadServlets(servletConfig);
        MiddlewareClassloaderFactory.getClassLoaderManager().register(this);
    }

    public static KonyCompositeServletManager getInstance() {
        return instance;
    }

    public static void initialize(ServletConfig config) {
        if (instance == null) {
            instance = new KonyCompositeServletManager(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getConfiguredServletWithGivenPath(String requestServletPath) {
        LOGGER.info((Object)"Inside getConfiguredServletWithGivenPath()");
        if (this.servletByRequestPath.get(requestServletPath) != null) {
            return this.servletByRequestPath.get(requestServletPath);
        }
        MiddlewareClassloaderFactory.getClassLoaderManager().acquireReadLock();
        try {
            Set<Map.Entry<Servlet, String[]>> configuredServlets = this.servletmap.entrySet();
            for (Map.Entry<Servlet, String[]> configuredServlet : configuredServlets) {
                String[] configuredServletUrlPatterns = configuredServlet.getValue();
                if (!AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(requestServletPath, configuredServletUrlPatterns)) continue;
                LOGGER.info((Object)"request pattern matched with configured Servlet pattern");
                this.servletByRequestPath.put(requestServletPath, configuredServlet.getKey());
                Servlet servlet = configuredServlet.getKey();
                return servlet;
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Exception while lokking up for servlets ", e);
        }
        finally {
            MiddlewareClassloaderFactory.getClassLoaderManager().releaseReadLock();
        }
        return null;
    }

    public boolean isServletsConfigured() {
        return !this.servletmap.isEmpty();
    }

    private void loadServlets(ServletConfig servletConfig) {
        AnnotationParsingUtil.loadServletsByAnnotation(this.servletmap, servletConfig);
        AnnotationParsingUtil.loadServletsByJson(this.servletmap, servletConfig);
    }

    @Override
    public void onUpdate(MiddlewareClassloaderEvent event) {
        this.servletmap.clear();
        this.servletByRequestPath.clear();
        this.loadServlets(this.servletConfig);
    }

    static {
        LOGGER = Logger.getLogger(AnnotationParsingUtil.class);
    }
}

