/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.servlet.filters;

import com.konylabs.middleware.classloader.MiddlewareClassloaderEvent;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderObserver;
import com.konylabs.middleware.servlet.filters.FilterMetadata;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.servlet.filters.KonyFilterChain;
import com.konylabs.middleware.servlet.utils.AnnotationParsingUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class KonyCompositeFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(KonyCompositeFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info((Object)"initializing filters");
        KonyFilterFactory konyFilterFactory = KonyFilterFactory.getInstance();
        konyFilterFactory.intializeConfiguredFiltersAndPutIntoCache(filterConfig);
        AnnotationParsingUtil.readServletsUsingInitParamsAndPutIntoCache(filterConfig, konyFilterFactory.servletMap, konyFilterFactory.staticResourcesList);
        MiddlewareClassloaderFactory.getClassLoaderManager().register(konyFilterFactory);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LOGGER.info((Object)"doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain)");
        try {
            KonyFilterChain konyFilterChain = KonyFilterFactory.getInstance().createAndFetchFilterChainAddFiltersTobeExecuted(filterChain, (HttpServletRequest)request);
            konyFilterChain.doFilter(request, response);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while executing filters ", (Throwable)e);
        }
    }

    public void destroy() {
        LOGGER.info((Object)"Invoking destroy");
        KonyFilterFactory.getInstance().destroy();
        MiddlewareClassloaderFactory.getClassLoaderManager().unregister(KonyFilterFactory.getInstance());
        KonyFilterFactory.clear();
        KonyFilterFactory.getInstance().filterConfig = null;
        KonyFilterFactory.konyFilterFactoryInstance = null;
    }

    private static class KonyFilterFactory
    implements MiddlewareClassloaderObserver {
        private static KonyFilterFactory konyFilterFactoryInstance = new KonyFilterFactory();
        private final List<Filter> allFiltersInOrder = new CopyOnWriteArrayList<Filter>();
        private final List<Filter> customFiltersInOrder = new CopyOnWriteArrayList<Filter>();
        private final Map<String, FilterMetadata> filterWithAnnotationMap = new ConcurrentHashMap<String, FilterMetadata>();
        private final Map<String, List<Filter>> filterCacheByUri = new HashMap<String, List<Filter>>();
        private FilterConfig filterConfig = null;
        private final Map<String, String> servletMap = new HashMap<String, String>();
        private final List<String> staticResourcesList = new ArrayList<String>();

        private KonyFilterFactory() {
        }

        @Override
        public void onUpdate(MiddlewareClassloaderEvent event) {
            try {
                this.destroyFiltersAndRemoveFromFilterMap(this.customFiltersInOrder);
                KonyFilterFactory.konyFilterFactoryInstance.customFiltersInOrder.clear();
                KonyFilterFactory.konyFilterFactoryInstance.filterCacheByUri.clear();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception while clearing the filters.", (Throwable)e);
            }
            this.intializeCustomFilters(this.filterConfig);
        }

        private static KonyFilterFactory getInstance() {
            if (konyFilterFactoryInstance == null) {
                konyFilterFactoryInstance = new KonyFilterFactory();
            }
            return konyFilterFactoryInstance;
        }

        private static void clear() {
            KonyFilterFactory.konyFilterFactoryInstance.filterWithAnnotationMap.clear();
            KonyFilterFactory.konyFilterFactoryInstance.allFiltersInOrder.clear();
            KonyFilterFactory.konyFilterFactoryInstance.filterCacheByUri.clear();
        }

        private void destroy() {
            for (Filter filter : this.allFiltersInOrder) {
                try {
                    filter.destroy();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception occurred while destroying filter", (Throwable)e);
                }
            }
        }

        private void destroyFiltersAndRemoveFromFilterMap(List<Filter> filtersInOrder) {
            for (Filter filter : filtersInOrder) {
                try {
                    filter.destroy();
                    this.allFiltersInOrder.remove(filter);
                    this.filterWithAnnotationMap.remove(filter.getClass().getName());
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception occurred while destroying filter", (Throwable)e);
                }
            }
        }

        private void setFiltersInOrder(List<Filter> sourceList, List<Filter> newList) {
            sourceList.clear();
            sourceList.addAll(newList);
        }

        private void intializeConfiguredFiltersAndPutIntoCache(FilterConfig filterConfig) {
            LOGGER.info((Object)"looking up for the configured filters");
            TreeMap<Integer, List<Filter>> allFilterOrderMap = new TreeMap<Integer, List<Filter>>();
            TreeMap<Integer, List<Filter>> customFilterOrderMap = new TreeMap<Integer, List<Filter>>();
            HashMap<String, FilterMetadata> customFilterAnnotationLookUp = new HashMap<String, FilterMetadata>();
            try {
                AnnotationParsingUtil.parseFiltersAndAddFiltersAnnotationsMapAndFiltersOrderMap(this.filterWithAnnotationMap, allFilterOrderMap, customFilterOrderMap, customFilterAnnotationLookUp);
                ArrayList<Filter> filterList = AnnotationParsingUtil.fetchFiltersInOrderAndExecuteInit(filterConfig, allFilterOrderMap);
                this.setFiltersInOrder(this.allFiltersInOrder, filterList);
                this.setFiltersInOrder(this.customFiltersInOrder, AnnotationParsingUtil.getListFromMap(customFilterOrderMap));
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Exception occurred while parsing filters ", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KonyFilterChain createAndFetchFilterChainAddFiltersTobeExecuted(FilterChain filterChain, HttpServletRequest request) {
            LOGGER.info((Object)"Inside createAndFetchFilterChainAddFiltersTobeExecuted()");
            ArrayList<Filter> filtersNeedToBeExecuted = new ArrayList<Filter>();
            String requestServletPath = AnnotationParsingUtil.getServletPath(request);
            if (this.filterCacheByUri.containsKey(requestServletPath)) {
                LOGGER.info((Object)"Found Filters in cache");
                return new KonyFilterChain(filterChain, this.filterCacheByUri.get(requestServletPath));
            }
            try {
                MiddlewareClassloaderFactory.getClassLoaderManager().acquireReadLock();
                LOGGER.info((Object)"Acquiring lock on classLoaderManager in createAndFetchFilterChainAddFiltersTobeExecuted()");
                block5: for (Filter filter : this.allFiltersInOrder) {
                    String[] urlPatterns;
                    IntegrationCustomFilter integrationRuntimeFilter = this.filterWithAnnotationMap.get(filter.getClass().getName()).getFilterAnnotation();
                    if (integrationRuntimeFilter.servletNames().length > 0) {
                        AnnotationParsingUtil.addFilterIfServletPathFromRequestMatchesConfigured(requestServletPath, integrationRuntimeFilter, filtersNeedToBeExecuted, filter, this.servletMap, this.staticResourcesList);
                        continue;
                    }
                    for (String configuredUrlPattern : urlPatterns = AnnotationParsingUtil.getUrlPatterns(integrationRuntimeFilter, filter)) {
                        if ("/*".equalsIgnoreCase(configuredUrlPattern)) {
                            LOGGER.info((Object)("Filter is mapped with any request pattern so added the filter: " + filter.getClass().getName()));
                            filtersNeedToBeExecuted.add(filter);
                            continue block5;
                        }
                        if (!AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(requestServletPath, configuredUrlPattern)) continue;
                        LOGGER.info((Object)("Filter pattern matched with request url pattern " + filter.getClass().getName()));
                        filtersNeedToBeExecuted.add(filter);
                        continue block5;
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Exception occurred while fetching required filters to be invoked", e);
            }
            finally {
                MiddlewareClassloaderFactory.getClassLoaderManager().releaseReadLock();
                LOGGER.info((Object)"Released lock on classLoaderManager in createAndFetchFilterChainAddFiltersTobeExecuted()");
            }
            this.filterCacheByUri.put(requestServletPath, filtersNeedToBeExecuted);
            return new KonyFilterChain(filterChain, filtersNeedToBeExecuted);
        }

        private void intializeCustomFilters(FilterConfig filterConfig) {
            TreeMap<Integer, List<Filter>> customFilterTreeMap = new TreeMap<Integer, List<Filter>>();
            try {
                AnnotationParsingUtil.parseCustomFilter(customFilterTreeMap, this.filterWithAnnotationMap);
                ArrayList<Filter> customFilterList = AnnotationParsingUtil.fetchFiltersInOrderAndExecuteInit(filterConfig, customFilterTreeMap);
                this.setFiltersInOrder(this.customFiltersInOrder, customFilterList);
                this.setFiltersInOrder(this.allFiltersInOrder, AnnotationParsingUtil.getFiltersAsList(this.filterWithAnnotationMap));
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception occurred while parsing filters ", (Throwable)e);
            }
        }
    }
}

