/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.servlet.filters;

import com.konylabs.middleware.response.RecordingResponseWrapper;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.tool.RecordingUtils;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareIOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

@IntegrationCustomFilter(filterOrder=70, servletNames={"MWServlet", "AppServices"}, defaultFilter=true)
public class RequestResponseInterceptorFilter
implements Filter {
    private boolean isRecordingEnabled;

    public void init(FilterConfig fConfig) throws ServletException {
        this.isRecordingEnabled = ConfigUtility.getBoolean((String)"KONY_SERVER_RECORD_SERVICE_REQUEST_RESPONSE", (boolean)false);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isRecordingEnabled) {
            String filePath = RecordingUtils.recordRequestAndReturnFilePath(request);
            File file = MiddlewareIOUtils.getFileForFileNameAndExtension(filePath, "_expected_output.json");
            response = new RecordingResponseWrapper((HttpServletResponse)response, new PrintWriter(file));
        }
        chain.doFilter(request, response);
    }
}

