/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.servlet.listeners;

import com.konylabs.middleware.classloader.MiddlewareClassloaderEvent;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderObserver;
import com.konylabs.middleware.servlet.utils.AnnotationParsingUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class KonyCompositeListener
implements ServletContextListener,
HttpSessionListener,
MiddlewareClassloaderObserver {
    private static final Logger LOGGER = Logger.getLogger(KonyCompositeListener.class);
    private final List<ServletContextListener> servletContextListenerList = new ArrayList<ServletContextListener>();
    private final List<HttpSessionListener> httpSessionListenerList = new ArrayList<HttpSessionListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent se) {
        MiddlewareClassloaderFactory.getClassLoaderManager().acquireReadLock();
        try {
            for (HttpSessionListener httpSessionListener : this.httpSessionListenerList) {
                httpSessionListener.sessionCreated(se);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while invoking sessionCreated() on http session listeners ", (Throwable)e);
        }
        finally {
            MiddlewareClassloaderFactory.getClassLoaderManager().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        MiddlewareClassloaderFactory.getClassLoaderManager().acquireReadLock();
        try {
            for (HttpSessionListener httpSessionListener : this.httpSessionListenerList) {
                httpSessionListener.sessionDestroyed(se);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while invoking sessionDestroyed() on http session isteners ", (Throwable)e);
        }
        finally {
            MiddlewareClassloaderFactory.getClassLoaderManager().releaseReadLock();
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.loadServletContextAndHttpSessionListenersAndRegisterToClassloader();
        MiddlewareClassloaderFactory.getClassLoaderManager().register(this);
        for (ServletContextListener servletContextListener : this.servletContextListenerList) {
            servletContextListener.contextInitialized(sce);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (ServletContextListener servletContextListener : this.servletContextListenerList) {
            servletContextListener.contextDestroyed(sce);
        }
    }

    @Override
    public void onUpdate(MiddlewareClassloaderEvent event) {
        this.httpSessionListenerList.clear();
        this.servletContextListenerList.clear();
        this.loadServletContextAndHttpSessionListenersAndRegisterToClassloader();
    }

    private void loadServletContextAndHttpSessionListenersAndRegisterToClassloader() {
        try {
            this.servletContextListenerList.addAll(AnnotationParsingUtil.getConfiguredCustomServletContextListeners());
            this.httpSessionListenerList.addAll(AnnotationParsingUtil.getConfiguredCustomHttpSessionListeners());
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Exception occurred while initializing custom lsteners", e);
        }
    }
}

