/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.servlet.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Predicate;
import com.kony.dataadapter.annotations.utilities.ClassUtil;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.servlet.IntegrationCustomServlet;
import com.konylabs.middleware.servlet.KonyCompositeServletManager;
import com.konylabs.middleware.servlet.ServletConfigJson;
import com.konylabs.middleware.servlet.filters.FilterMetadata;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.servlet.listeners.IntegrationHttpSessionListener;
import com.konylabs.middleware.servlet.listeners.IntegrationServletContextListener;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public final class AnnotationParsingUtil {
    private static final Logger LOGGER = Logger.getLogger(AnnotationParsingUtil.class);

    private AnnotationParsingUtil() {
    }

    public static Set<Class<?>> getAnnotatedTypesWithGivenAnnotation(Class<? extends Annotation> annotation) {
        LOGGER.info((Object)"inside getAnnotatedTypesWithGivenAnnotation()");
        Set<Class<Object>> typesAnnotatedWith = new HashSet();
        try {
            ConfigurationBuilder configurationBuilder = AnnotationParsingUtil.getConfigurationBuilder();
            configurationBuilder.setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
            Reflections reflections = new Reflections((Configuration)configurationBuilder);
            typesAnnotatedWith = reflections.getTypesAnnotatedWith(annotation);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"IOException occurred while scanning annotations : ", e);
        }
        return typesAnnotatedWith;
    }

    public static void parseFiltersAndAddFiltersAnnotationsMapAndFiltersOrderMap(Map<String, FilterMetadata> filterWithAnnotationMap, TreeMap<Integer, List<Filter>> orderMap, TreeMap<Integer, List<Filter>> customFilterOrderMap, Map<String, FilterMetadata> customFilterAnnotationLookUp) {
        Set<Class<?>> typesAnnotatedWith = AnnotationParsingUtil.getAnnotatedTypesWithGivenAnnotation(IntegrationCustomFilter.class);
        LOGGER.info((Object)("Trying to load a total filters of size: " + typesAnnotatedWith.size()));
        if (CollectionUtils.isNotEmpty(typesAnnotatedWith)) {
            for (Class<?> annotatedClass : typesAnnotatedWith) {
                try {
                    IntegrationCustomFilter annotation = annotatedClass.getAnnotation(IntegrationCustomFilter.class);
                    if (annotation == null) continue;
                    Filter filter = (Filter)annotatedClass.newInstance();
                    FilterMetadata filterMetadata = new FilterMetadata(filter, annotation);
                    if (!annotation.defaultFilter()) {
                        customFilterAnnotationLookUp.put(annotatedClass.getName(), filterMetadata);
                        AnnotationParsingUtil.addFiltersInMap(customFilterOrderMap, filterMetadata);
                    }
                    filterWithAnnotationMap.put(annotatedClass.getName(), filterMetadata);
                    AnnotationParsingUtil.addFiltersInMap(orderMap, filterMetadata);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Exception occurred while trying to read annotations: ", e);
                }
            }
        }
    }

    public static void parseCustomFilter(TreeMap<Integer, List<Filter>> customFilterTreeMap, Map<String, FilterMetadata> filterAnnotationMap) {
        Set<Class<?>> typesAnnotatedWith = AnnotationParsingUtil.getAnnotatedTypesWithGivenAnnotation(IntegrationCustomFilter.class);
        LOGGER.info((Object)("Trying to load a total filters of size: " + typesAnnotatedWith.size()));
        if (CollectionUtils.isNotEmpty(typesAnnotatedWith)) {
            for (Class<?> annotatedClass : typesAnnotatedWith) {
                try {
                    IntegrationCustomFilter annotation = annotatedClass.getAnnotation(IntegrationCustomFilter.class);
                    if (!AnnotationParsingUtil.isCustomFilter(annotation)) continue;
                    Filter filter = (Filter)annotatedClass.newInstance();
                    FilterMetadata filterMetadata = new FilterMetadata(filter, annotation);
                    filterAnnotationMap.put(annotatedClass.getName(), filterMetadata);
                    AnnotationParsingUtil.addFiltersInMap(customFilterTreeMap, filterMetadata);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Exception occurred while trying to read annotations: ", e);
                }
            }
        }
    }

    public static List<Filter> getListFromMap(Map<Integer, List<Filter>> orderMap) {
        return orderMap.values().stream().flatMap(filter -> filter.stream()).collect(Collectors.toList());
    }

    public static ArrayList<Filter> fetchFiltersInOrderAndExecuteInit(FilterConfig filterConfig, TreeMap<Integer, List<Filter>> orderMap) {
        LOGGER.info((Object)"fetching filters in order and execute init");
        ArrayList<Filter> filtersInOrder = new ArrayList<Filter>();
        Set<Integer> keySet = orderMap.keySet();
        for (Integer key : keySet) {
            List<Filter> list = orderMap.get(key);
            for (Filter filter : list) {
                try {
                    LOGGER.debug((Object)("initializing filter: " + filter.getClass().getName()));
                    filter.init(filterConfig);
                    filtersInOrder.add(filter);
                }
                catch (Throwable e) {
                    LOGGER.error((Object)("Unable initialize Filter: " + filter.getClass().getName()), e);
                }
            }
        }
        return filtersInOrder;
    }

    public static void readServletsUsingInitParamsAndPutIntoCache(FilterConfig filterConfig, Map<String, String> servletMap, List<String> staticResourcesList) {
        LOGGER.info((Object)"inside readServletsUsingInitParamsAndPutIntoCache() method");
        try {
            String[] servlets;
            String servletNamesWithUrlPatterns = filterConfig.getInitParameter("konyservlets");
            String staticResourcesNames = filterConfig.getInitParameter("staticResources");
            if (StringUtils.isNotBlank((String)servletNamesWithUrlPatterns) && (servlets = servletNamesWithUrlPatterns.split(",")) != null && servlets.length > 0) {
                for (String servlet : servlets) {
                    String[] servletNameAndUrl = servlet.split("-");
                    if (servletNameAndUrl.length < 2) continue;
                    String servletName = servletNameAndUrl[0].trim();
                    String servletUrl = servletNameAndUrl[1].trim();
                    servletMap.put(servletName, servletUrl);
                }
            }
            if (StringUtils.isNotBlank((String)staticResourcesNames)) {
                String[] staticResources;
                for (String staticResource : staticResources = staticResourcesNames.split(",")) {
                    staticResourcesList.add(staticResource);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while reading filter init param", (Throwable)e);
        }
    }

    public static String[] getUrlPatterns(IntegrationCustomFilter integrationRuntimeFilter, Filter filter) {
        String[] urlPatterns = null;
        if (integrationRuntimeFilter.urlPatterns().length > 0) {
            urlPatterns = integrationRuntimeFilter.urlPatterns();
        } else if (StringUtils.isNotBlank((String)integrationRuntimeFilter.filterName())) {
            urlPatterns = new String[]{integrationRuntimeFilter.filterName()};
        } else {
            String[] split = filter.getClass().getName().split("\\.");
            urlPatterns = new String[]{split[split.length - 1]};
        }
        return urlPatterns;
    }

    public static boolean isRequestPatternMatchedWithConfigured(String actualUrlPath, String configuredUrlpath) {
        Pattern p;
        Matcher m;
        if (actualUrlPath.startsWith("/") && !configuredUrlpath.startsWith("/")) {
            configuredUrlpath = "/" + configuredUrlpath;
        }
        return (m = (p = Pattern.compile(Pattern.quote(configuredUrlpath))).matcher(actualUrlPath)).find() && actualUrlPath.startsWith(configuredUrlpath);
    }

    public static void addFilterIfServletPathFromRequestMatchesConfigured(String requestServletPath, IntegrationCustomFilter integrationRuntimeFilter, List<Filter> filtersNeedToBeExecuted, Filter filter, Map<String, String> servletMap, List<String> staticResourcesList) {
        String[] servletNames;
        LOGGER.info((Object)"Inside addFilterIfServletPathFromRequestMatchesConfigured()");
        for (String servletName : servletNames = integrationRuntimeFilter.servletNames()) {
            String configuredServeltPath = servletMap.get(servletName);
            if ("MWServlet".equals(servletName) && AnnotationParsingUtil.findExecutingServletForTheRequestIsMWServlet(requestServletPath, servletMap, staticResourcesList)) {
                LOGGER.info((Object)("Found the filter is mapped to MWServlet: " + filter.getClass().getName()));
                filtersNeedToBeExecuted.add(filter);
                break;
            }
            if (!StringUtils.isNotBlank((String)configuredServeltPath) || !AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(requestServletPath, configuredServeltPath)) continue;
            LOGGER.info((Object)("request pattern matched with configured url pattern : " + filter.getClass().getName()));
            filtersNeedToBeExecuted.add(filter);
            break;
        }
    }

    public static boolean findExecutingServletForTheRequestIsMWServlet(String requestServletPath, Map<String, String> servletMap, List<String> staticResources) {
        LOGGER.info((Object)"Inside findExecutingServletForTheRequestIsMWServlet()");
        boolean isServletExecutedIsMWServlet = true;
        for (String staticResource : staticResources) {
            if (!AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(requestServletPath, staticResource)) continue;
            return false;
        }
        Collection<String> configuredServletUrlPatternsInWebxml = servletMap.values();
        for (String configuredServletUrlPatternINWebxml : configuredServletUrlPatternsInWebxml) {
            if (!AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(requestServletPath, configuredServletUrlPatternINWebxml)) continue;
            isServletExecutedIsMWServlet = false;
            break;
        }
        if (isServletExecutedIsMWServlet && KonyCompositeServletManager.getInstance() != null) {
            isServletExecutedIsMWServlet = KonyCompositeServletManager.getInstance().getConfiguredServletWithGivenPath(requestServletPath) == null;
        }
        LOGGER.info((Object)("isServletExecutedIsMWServlet: " + isServletExecutedIsMWServlet));
        return isServletExecutedIsMWServlet;
    }

    public static ArrayList<ServletContextListener> getConfiguredCustomServletContextListeners() {
        ArrayList<ServletContextListener> servletContextListenerList = new ArrayList<ServletContextListener>();
        Set<Class<?>> customServletListners = AnnotationParsingUtil.getAnnotatedTypesWithGivenAnnotation(IntegrationServletContextListener.class);
        LOGGER.info((Object)("Trying to load a total custom http servlet context listeners of size: " + customServletListners.size()));
        if (customServletListners != null && CollectionUtils.isNotEmpty(customServletListners)) {
            for (Class<?> customServletListner : customServletListners) {
                try {
                    servletContextListenerList.add((ServletContextListener)customServletListner.newInstance());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Exception occurred while initializing ServletContextListener", e);
                }
            }
        }
        return servletContextListenerList;
    }

    public static ArrayList<HttpSessionListener> getConfiguredCustomHttpSessionListeners() {
        ArrayList<HttpSessionListener> httpSessionListenerList = new ArrayList<HttpSessionListener>();
        Set<Class<?>> customHttpListners = AnnotationParsingUtil.getAnnotatedTypesWithGivenAnnotation(IntegrationHttpSessionListener.class);
        LOGGER.info((Object)("Trying to load a total custom http session listeners of size: " + customHttpListners.size()));
        if (customHttpListners != null && CollectionUtils.isNotEmpty(customHttpListners)) {
            for (Class<?> customHttpListner : customHttpListners) {
                try {
                    httpSessionListenerList.add((HttpSessionListener)customHttpListner.newInstance());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)"Exception occurred while initializing HttpSessionListener", e);
                }
            }
        }
        return httpSessionListenerList;
    }

    public static ConfigurationBuilder getConfigurationBuilder() throws MiddlewareException {
        MiddlewareClassloaderManager middlewareClassLoaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
        ClassLoader classloader = middlewareClassLoaderManager.getMiddlewareLibClassLoader();
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.addClassLoader(classloader);
        String basePackages = ConfigUtility.getProperty((String)"kony.server.basepackage.list");
        LOGGER.debug((Object)("Value for KONY_SERVER_BASE_PACKAGE_LIST: " + basePackages));
        List<String> basepackageList = AnnotationParsingUtil.getCustomBasePackageList(basePackages);
        List forPackage = ClassUtil.forPackage((String)"com.konylabs", (ClassLoader[])new ClassLoader[]{classloader});
        forPackage.addAll(middlewareClassLoaderManager.getResourceUrls(basepackageList));
        AnnotationParsingUtil.setFilterByBasePackage(configurationBuilder, basepackageList);
        configurationBuilder.setUrls((Collection)forPackage);
        return configurationBuilder;
    }

    public static List<ServletConfigJson> convertRequestJsonToServletConfigJson(String requestJson, String key) {
        ArrayList<ServletConfigJson> ServletConfigJsonList = new ArrayList<ServletConfigJson>();
        if (StringUtils.isEmpty((String)requestJson)) {
            return ServletConfigJsonList;
        }
        ObjectMapper jsonTobjectMapper = new ObjectMapper();
        try {
            JSONObject reqObj = new JSONObject(requestJson);
            return (List)jsonTobjectMapper.readValue(reqObj.get(key).toString(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, ServletConfigJson.class));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while parsing the request json", (Throwable)e);
            return ServletConfigJsonList;
        }
    }

    public static List<ServletConfigJson> getConfiguredServletsFromJson(String requestJson) {
        return AnnotationParsingUtil.convertRequestJsonToServletConfigJson(requestJson, "servlets");
    }

    public static void loadServletsByAnnotation(Map<Servlet, String[]> servletmap, ServletConfig servletConfig) {
        Set<Class<?>> servletsWithAnnotations = AnnotationParsingUtil.getAnnotatedTypesWithGivenAnnotation(IntegrationCustomServlet.class);
        LOGGER.info((Object)("Trying to load a total custom servlets of size: " + servletsWithAnnotations.size()));
        if (servletsWithAnnotations != null && CollectionUtils.isNotEmpty(servletsWithAnnotations)) {
            for (Class<?> annotatedClass : servletsWithAnnotations) {
                try {
                    IntegrationCustomServlet annotation = annotatedClass.getAnnotation(IntegrationCustomServlet.class);
                    Servlet servlet = (Servlet)annotatedClass.newInstance();
                    servlet.init(servletConfig);
                    servletmap.put(servlet, annotation.urlPatterns());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)("Unable instantiate Servlet: " + annotatedClass.getName()), e);
                }
            }
        }
    }

    public static void loadServletsByJson(Map<Servlet, String[]> servletmap, ServletConfig servletConfig) {
        String configuredServlets = ConfigUtility.getProperty((String)"KONY_SERVER_DYNAMIC_WEB_CONFIGURATION");
        List<ServletConfigJson> configuredServletsFromJson = AnnotationParsingUtil.getConfiguredServletsFromJson(configuredServlets);
        for (ServletConfigJson servletConfigJson : configuredServletsFromJson) {
            try {
                Servlet servlet = (Servlet)MiddlewareClassloaderFactory.getClassLoaderManager().getInstance(servletConfigJson.getClassName());
                servlet.init(servletConfig);
                servletmap.put(servlet, servletConfigJson.getUrlPattern());
            }
            catch (Throwable e) {
                LOGGER.error((Object)("Unable instantiate Servlet: " + servletConfigJson.getClassName()), e);
            }
        }
    }

    public static boolean isRequestPatternMatchedWithConfigured(String configuredUrlpath, String[] configuredServletUrlPatterns) {
        for (String configuredServletUrlPattern : configuredServletUrlPatterns) {
            if (!AnnotationParsingUtil.isRequestPatternMatchedWithConfigured(configuredUrlpath, configuredServletUrlPattern)) continue;
            return true;
        }
        return false;
    }

    public static String getServletPath(HttpServletRequest request) {
        return request.getRequestURI().replaceFirst(request.getContextPath(), "");
    }

    public static List<Filter> getFiltersAsList(Map<String, FilterMetadata> filterAnnotationMap) {
        return filterAnnotationMap.entrySet().stream().sorted((e1, e2) -> Integer.valueOf(((FilterMetadata)e1.getValue()).getFilterAnnotation().filterOrder()).compareTo(((FilterMetadata)e2.getValue()).getFilterAnnotation().filterOrder())).map(e -> ((FilterMetadata)e.getValue()).getFilter()).collect(Collectors.toList());
    }

    private static void addFiltersInMap(Map<Integer, List<Filter>> orderMap, FilterMetadata filterMetadata) {
        List<Filter> filterList = orderMap.get(filterMetadata.getFilterAnnotation().filterOrder());
        if (filterList == null) {
            filterList = new ArrayList<Filter>();
        }
        filterList.add(filterMetadata.getFilter());
        orderMap.put(filterMetadata.getFilterAnnotation().filterOrder(), filterList);
    }

    private static boolean isCustomFilter(IntegrationCustomFilter annotation) {
        return annotation != null && !annotation.defaultFilter();
    }

    private static void setFilterByBasePackage(ConfigurationBuilder configurationBuilder, List<String> basepackageList) {
        if (CollectionUtils.isEmpty(basepackageList)) {
            return;
        }
        FilterBuilder filterBuilder = new FilterBuilder();
        basepackageList.forEach(basePackage -> filterBuilder.include(FilterBuilder.prefix((String)basePackage)));
        configurationBuilder.filterInputsBy((Predicate)filterBuilder);
    }

    private static List<String> getCustomBasePackageList(String listOfBasePackage) {
        if (StringUtils.isNotBlank((String)listOfBasePackage)) {
            return Arrays.asList(listOfBasePackage.split(","));
        }
        return null;
    }
}

