/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.session.impl;

import com.konylabs.middleware.session.Session;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.apache.http.impl.cookie.BasicClientCookie;

public abstract class AbstractSessionImpl
implements Session {
    private static final long serialVersionUID = -1967176900863944419L;
    protected static final String KCOOKIE = "KCookie";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEISCookie(Cookie cookie) {
        if (cookie != null) {
            List<Cookie> cookies;
            List<Cookie> list = cookies = this.getCookiesCore();
            synchronized (list) {
                this.removeEISCookieFromSession(cookie);
                if (!cookie.isExpired(new Date())) {
                    cookies.add(cookie);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cookie> getEISCookies() {
        List<Cookie> cookies;
        List<Cookie> list = cookies = this.getCookiesCore();
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Cookie>(cookies));
        }
    }

    public Cookie getEISCookieByName(String name) {
        for (Cookie cookie : this.getEISCookies()) {
            if (!StringUtils.equals((String)name, (String)cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public Cookie getEISCookieByName_Domain_Path(String name, String domain, String path) {
        for (Cookie cookie : this.getEISCookies()) {
            if (!StringUtils.equals((String)name, (String)cookie.getName()) || !StringUtils.equals((String)domain, (String)cookie.getDomain()) || !StringUtils.equals((String)path, (String)cookie.getPath())) continue;
            return cookie;
        }
        return null;
    }

    public void addEISCookies(List<Cookie> cookieList) {
        if (cookieList != null) {
            for (Cookie cookie : cookieList) {
                this.addEISCookie(cookie);
            }
        }
    }

    public void addEISCookie(String name, String value) {
        this.addEISCookie(name, value, null, null, false);
    }

    public void addEISCookie(String name, String value, String path, String domain, boolean secure) {
        this.addEISCookie(name, value, path, domain, secure, null);
    }

    public void addEISCookie(String name, String value, String path, String domain, boolean secure, Date expiryDate) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setSecure(secure);
        cookie.setExpiryDate(expiryDate);
        this.addEISCookie((Cookie)cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEISCookieFromSession(Cookie cookie) {
        List<Cookie> cookies;
        CookieIdentityComparator cookieComparator = new CookieIdentityComparator();
        List<Cookie> list = cookies = this.getCookiesCore();
        synchronized (list) {
            Iterator<Cookie> it = cookies.iterator();
            while (it.hasNext()) {
                if (cookieComparator.compare(cookie, it.next()) != 0) continue;
                it.remove();
                break;
            }
        }
    }

    public void removeEISCookiesFromSession(List<Cookie> cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.removeEISCookieFromSession(cookie);
            }
        }
    }

    protected List<Cookie> getCookiesCore() {
        return (List)this.getAttribute(KCOOKIE);
    }
}

