/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.session.impl;

import com.konylabs.middleware.session.impl.AbstractSessionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;

public class SessionImpl
extends AbstractSessionImpl {
    private static final Logger LOGGER = Logger.getLogger(SessionImpl.class);
    private static final long serialVersionUID = 3977722213267289288L;
    private final HashMap<String, Object> session = new HashMap();
    private BiConsumer<String, Object> testSessionListener;

    public SessionImpl() {
        this.setAttribute("KCookie", Collections.synchronizedList(new ArrayList()));
    }

    public SessionImpl(BiConsumer<String, Object> sessionListener) {
        this();
        this.testSessionListener = sessionListener;
    }

    public Object getAttribute(String name) {
        return this.session.get(name);
    }

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return "sessionID";
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public Enumeration<String> getAttributeNames() {
        Vector<String> v = new Vector<String>();
        if (this.session == null) {
            return v.elements();
        }
        v.addAll(this.session.keySet());
        return v.elements();
    }

    public long getMaxInactiveInterval() {
        return 0L;
    }

    public void invalidate() {
    }

    public void removeAttribute(String name) {
        this.session.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.testSessionListener != null) {
            LOGGER.debug((Object)String.format("Adding the session parameter [%s : %s] into the test response", name, value));
            this.testSessionListener.accept(name, value);
        }
        this.session.put(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
    }

    public boolean containsKey(String key) {
        if (key == null) {
            return false;
        }
        return this.session.containsKey(key);
    }
}

