/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.healthcheck.HealthCheckUtils;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.tenant.ReadableTenantEnvManager;
import com.konylabs.middleware.tenant.TenantBean;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MTReadableTenantEnvManager
implements ReadableTenantEnvManager {
    private static final Logger LOGGER = Logger.getLogger(MTReadableTenantEnvManager.class);
    private LoadingCache<String, TenantBean<AppCache>> tenantEnvLRUCache;

    void setCache(LoadingCache<String, TenantBean<AppCache>> tenantEnvLRUCache) {
        this.tenantEnvLRUCache = tenantEnvLRUCache;
    }

    public Set<String> getActiveTenants() {
        return this.tenantEnvLRUCache.asMap().keySet();
    }

    public <T extends Cacheable> TenantBean<T> getTenantBean(String tenantIdentifier, Class<T> clazz) throws TenantException {
        try {
            return (TenantBean)this.tenantEnvLRUCache.get((Object)tenantIdentifier);
        }
        catch (CacheLoader.InvalidCacheLoadException | ExecutionException e) {
            LOGGER.error((Object)("Tenant not found with the tenant key : " + tenantIdentifier), e);
            TenantException.throwTenantException((String)tenantIdentifier, (Exception)e);
            return null;
        }
    }

    public String getTenantIdentifierFromServerName(String serverName) {
        return StringUtils.contains((String)serverName, (char)'.') ? serverName.substring(0, serverName.indexOf(46)) : null;
    }

    public String getHealthCheck(CacheDirector cacheDirector) {
        return new HealthCheckUtils().getHealthCheck(null, cacheDirector);
    }
}

