/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.impl.AbstractTenantBeanBuilder;
import com.konylabs.middleware.tenant.impl.TenantBeanImpl;
import com.konylabs.middleware.tenant.impl.TenantConfigBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MTTenantBeanBuilder<T extends Cacheable>
extends AbstractTenantBeanBuilder<T> {
    private static final Logger LOGGER = Logger.getLogger(MTTenantBeanBuilder.class);

    public TenantBean<T> build() throws TenantException {
        LOGGER.debug((Object)"Inside multi tenant bean builder.");
        if (this.getTenantBean() != null) {
            LOGGER.debug((Object)"Cloning tenant bean for service test flow.");
            return this.cloneTenantBean();
        }
        String tenantIdentifier = (String)this.envConfigProps.get("tenant_identifier");
        String schemaName = (String)this.envConfigProps.get("schema_name");
        if (StringUtils.isBlank((String)tenantIdentifier) || this.envConfigProps.size() <= 0) {
            LOGGER.error((Object)("Tenant not found with given tenant identifier : " + tenantIdentifier));
            throw new TenantException(String.valueOf(13011), "Tenant not found");
        }
        this.fetchAndSetConfigProperty(EnvironmentProperties.KONY_SERVER_MAX_REQUEST_PER_MIN.name(), "60");
        this.fetchAndSetConfigProperty(EnvironmentProperties.KONY_SERVER_TO_IDENTITY_AUTH_HEADER.name(), null);
        this.fetchAndSetConfigProperty("consumer_key", null);
        this.fetchAndSetConfigProperty("consumer_secret", null);
        return new TenantBeanImpl(new TenantConfigBean(tenantIdentifier, schemaName, this.envConfigProps), this.getAppCache());
    }

    private void fetchAndSetConfigProperty(String key, String defaultValue) {
        if (StringUtils.isBlank((String)((String)this.envConfigProps.get(key)))) {
            String value = ConfigUtility.getProperty((String)key, (String)defaultValue);
            LOGGER.info((Object)("Value of key " + key + " is " + value));
            if (StringUtils.isNotBlank((String)value)) {
                this.envConfigProps.put(key, value);
            }
        }
    }
}

