/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.controller.CacheUpdateHandler;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.service.EnvironmentService;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.impl.AbstractWritableTenantEnvManager;
import com.konylabs.middleware.tenant.impl.MTReadableTenantEnvManager;
import com.konylabs.middleware.tenant.impl.MTTenantBeanBuilder;
import com.konylabs.middleware.tenant.impl.MultiTenantAppCache;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class MTWritableTenantEnvManager
extends AbstractWritableTenantEnvManager<MTReadableTenantEnvManager> {
    private static final Logger LOGGER = Logger.getLogger(MTWritableTenantEnvManager.class);
    private final long lruLimit = ConfigUtility.getLongProperty((String)"KONY_SERVER_TENANT_LRU_CACHE_EVICTION_LIMIT", (long)200L);
    private final LoadingCache<String, TenantBean<AppCache>> tenantEnvLRUCache = CacheBuilder.newBuilder().maximumSize(this.lruLimit).build((CacheLoader)new CacheLoader<String, TenantBean<AppCache>>(){

        public TenantBean<AppCache> load(String key) throws Exception {
            Map<String, String> envConfigProps = MTWritableTenantEnvManager.this.multiTenantDBService.getEnvironmentDetails(key);
            return new MTTenantBeanBuilder<Map<String, String>>().with(envConfigProps).with((Cacheable)new MultiTenantAppCache(envConfigProps.get("schema_name"), envConfigProps.get(EnvironmentProperties.ENVIRONMENT_ID.name()))).build();
        }
    });

    public MTWritableTenantEnvManager(EnvironmentService dBService) {
        super(dBService, new MTReadableTenantEnvManager());
        ((MTReadableTenantEnvManager)this.getReadableTenantEnvManager()).setCache(this.tenantEnvLRUCache);
    }

    public <T extends Cacheable> TenantBean<T> loadTenantBean(String tenantIdentifier, Class<T> clazz) throws TenantException {
        Map<String, String> envConfigProps = this.multiTenantDBService.getEnvironmentDetails(tenantIdentifier);
        return new MTTenantBeanBuilder<Map<String, String>>().with(envConfigProps).build();
    }

    public void loadIntoCache(String tenantIdentifier, AppVersion appVersion, CacheUpdateHandler cacheUpdateHandler) throws TenantException, SQLException {
        try {
            TenantBean tenantBean = (TenantBean)this.tenantEnvLRUCache.get((Object)tenantIdentifier);
            AppCache appCache = (AppCache)tenantBean.getAppCache();
            if (appCache.getServiceVersionCache().contains(appVersion.getAppId())) {
                appCache.getServiceVersionCache().putVersion(appVersion);
            }
            String envGuid = tenantBean.getEnvProperty(EnvironmentProperties.ENVIRONMENT_ID.name());
            if (appCache.getAllKeys().contains(appVersion)) {
                cacheUpdateHandler.updateCache(envGuid);
            } else {
                cacheUpdateHandler.doNotUpdate(envGuid);
            }
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)("Exception while getting tenant bean with identifier : " + tenantIdentifier), (Throwable)e);
            TenantException.throwTenantException((String)tenantIdentifier, (Exception)e);
        }
    }

    public void initialize() {
    }

    public void removeTenant(String tenantIdentifier) {
        this.tenantEnvLRUCache.invalidate((Object)tenantIdentifier);
    }
}

