/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.kony.mapper.javascript.JavaScriptEngineWrapperFactory;
import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.ApplicationInfoDAO;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.registry.AppRegistryException;
import com.konylabs.middleware.registry.ApplicationInfo;
import com.konylabs.middleware.registry.impl.AbstractAppCache;
import com.konylabs.middleware.registry.impl.ApplicationHelper;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.service.EnvironmentService;
import com.konylabs.middleware.service.EnvironmentServiceImpl;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MultiTenantAppCache
extends AbstractAppCache {
    private static final Logger LOGGER = Logger.getLogger(MultiTenantAppCache.class);
    private String schemaName;
    private String envGuid;
    private EnvironmentService environmentService;
    private long LRULimit = ConfigUtility.getLongProperty((String)"KONY_SERVER_APP_LRU_CACHE_EVICTION_LIMIT", (long)5L);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(ConfigUtility.getIntProperty((String)"KONY_NS_JS_MONITOR_THREAD_POOL_SIZE", (int)30));
    private static final int MAX_CPU_TIME = ConfigUtility.getIntProperty((String)"KONY_NS_JS_MONITOR_CPU_LIMIT", (int)300000);
    private static final int MAX_MEMORY = ConfigUtility.getIntProperty((String)"KONY_NS_JS_MONITOR_MEMORY_LIMIT", (int)0x500000);
    private static final List<Class<?>> allowedClasses = new ArrayList();
    private final RemovalListener<AppVersion, ApplicationMetadata> removeScriptsFromJSWrapper = notification -> {
        if (!RemovalCause.REPLACED.equals((Object)notification.getCause())) {
            LOGGER.debug((Object)("Application " + ((AppVersion)notification.getKey()).toString() + " got evicted because of " + notification.getCause().toString()));
            this.getJavaScriptEngineWrapper().removeScriptsByNamespace(((AppVersion)notification.getKey()).toString());
        }
    };
    private final LoadingCache<AppVersion, ApplicationMetadata> konyLRUAppCache = CacheBuilder.newBuilder().maximumSize(this.LRULimit).removalListener(this.removeScriptsFromJSWrapper).build((CacheLoader)new CacheLoader<AppVersion, ApplicationMetadata>(){

        public ApplicationMetadata load(AppVersion appVersion) throws Exception {
            return MultiTenantAppCache.this.environmentService.fetchAppMetadataFromDatabase(appVersion, MultiTenantAppCache.this.schemaName, MultiTenantAppCache.this.envGuid, MultiTenantAppCache.this);
        }
    });

    public MultiTenantAppCache(String schemaName, String envGuid) {
        super(JavaScriptEngineWrapperFactory.getNSJavaScriptEngineWrapper((int)MAX_CPU_TIME, (int)MAX_MEMORY, allowedClasses, (ExecutorService)EXECUTOR_SERVICE));
        this.schemaName = schemaName;
        this.envGuid = envGuid;
        this.environmentService = new EnvironmentServiceImpl();
    }

    public MultiTenantAppCache(String schemaName, String envGuid, EnvironmentService environmentService) {
        super(JavaScriptEngineWrapperFactory.getNSJavaScriptEngineWrapper((int)MAX_CPU_TIME, (int)MAX_MEMORY, allowedClasses, (ExecutorService)EXECUTOR_SERVICE));
        this.schemaName = schemaName;
        this.envGuid = envGuid;
        this.environmentService = environmentService;
    }

    public ApplicationMetadata getAppMetadata(AppVersion appVersion) {
        try {
            return (ApplicationMetadata)this.konyLRUAppCache.get((Object)appVersion);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)("Exception while getting the app cahe with app version : " + appVersion), (Throwable)e);
        }
        catch (CacheLoader.InvalidCacheLoadException ice) {
            LOGGER.error((Object)("No app metadata found for the app version : " + appVersion), (Throwable)ice);
        }
        return null;
    }

    public Set<AppVersion> getAllKeys() {
        return this.konyLRUAppCache.asMap().keySet();
    }

    @Override
    public void remove(AppVersion appVersion) {
        LOGGER.debug((Object)("Removing appVersion " + appVersion + " from appCache"));
        super.remove(appVersion);
        this.konyLRUAppCache.invalidate((Object)appVersion);
    }

    @Override
    public void addAppMetadata(AppVersion appVersion, ApplicationMetadata appMetadata) {
        super.addAppMetadata(appVersion, appMetadata);
        this.konyLRUAppCache.put((Object)appVersion, (Object)appMetadata);
    }

    @Override
    protected String getHighestVersion(String appId) {
        try {
            List appsList = ((ApplicationInfoDAO)DAOFactory.getDAO(ApplicationInfoDAO.class)).getAppInfoList(appId, this.schemaName, this.envGuid);
            for (ApplicationInfo appInfo : appsList) {
                try {
                    ApplicationHelper.buildAppMetadataFromAppInfo(appInfo, appInfo.getAppVersion(), this, appId);
                }
                catch (AppRegistryException e) {
                    LOGGER.error((Object)("Appmetadata build failed for appId " + appInfo.getApplicationId()), (Throwable)e);
                }
                this.getServiceVersionCache().putVersion(appInfo.getAppVersion());
            }
            this.getFrontendResourceIdentifier().getResourceIdentifierBuilder().build();
            return this.getServiceVersionCache().getHighestVersion(appId);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Exception occured while getting highest version of service " + appId + " from database"));
            return null;
        }
    }

    static {
        try {
            String allowedClassNames = ConfigUtility.getProperty((String)"KONY_NS_JS_ALLOWED_CLASSES");
            if (StringUtils.isNotBlank((CharSequence)allowedClassNames)) {
                ArrayList<String> allowedClassesList = new ArrayList<String>(Arrays.asList(allowedClassNames.split(",")));
                for (String allowedClass : allowedClassesList) {
                    try {
                        allowedClasses.add(Class.forName(allowedClass));
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error((Object)"Failed to load class allowed classes list for JS Sandbox", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to initialize nashron sandbox restricted class loading", (Throwable)e);
        }
    }
}

