/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.controller.CacheUpdateHandler;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.registry.impl.KonyAppCache;
import com.konylabs.middleware.service.EnvironmentService;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.impl.AbstractWritableTenantEnvManager;
import com.konylabs.middleware.tenant.impl.STReadableTenantEnvManager;
import com.konylabs.middleware.tenant.impl.STTenantBeanBuilder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class STWritableTenantEnvManager
extends AbstractWritableTenantEnvManager<STReadableTenantEnvManager> {
    private Map<String, TenantBean<AppCache>> tenantCache = new HashMap<String, TenantBean<AppCache>>();

    public STWritableTenantEnvManager(EnvironmentService dbService) {
        super(dbService, new STReadableTenantEnvManager());
        ((STReadableTenantEnvManager)this.getReadableTenantEnvManager()).setCache(this.tenantCache);
    }

    public void loadIntoCache(String tenantIdentifier, AppVersion appVersion, CacheUpdateHandler tenantHandler) throws SQLException, TenantException {
        String envGuid = this.tenantCache.keySet().iterator().next();
        tenantHandler.updateCache(envGuid);
    }

    public <T extends Cacheable> TenantBean<T> loadTenantBean(String tenantIdentifier, Class<T> clazz) throws TenantException {
        this.tenantCache.clear();
        Map<String, String> envConfigProps = this.multiTenantDBService.getEnvironmentDetails();
        TenantBean tenantBeanWithChangedEnv = new STTenantBeanBuilder<Map<String, String>>().with(envConfigProps).with((Cacheable)new KonyAppCache()).build();
        this.tenantCache.put(envConfigProps.get(EnvironmentProperties.ENVIRONMENT_ID.name()), (TenantBean<AppCache>)tenantBeanWithChangedEnv);
        return tenantBeanWithChangedEnv;
    }

    public void initialize() throws TenantException {
        this.loadTenantBean(null);
    }

    public void removeTenant(String tenantIdentifier) {
    }
}

