/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tenant.impl;

import com.kony.api.gateway.GatewayConfig;
import com.kony.api.gateway.GatewayException;
import com.kony.api.gateway.GatewayHelper;
import com.kony.api.gateway.util.ServiceType;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.util.EqualsHelper;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.registry.Cacheable;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.tenant.impl.TenantConfigBean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class TenantBeanImpl<T extends Cacheable>
implements TenantBean<T> {
    private static final Logger LOGGER = Logger.getLogger(TenantBeanImpl.class);
    private static final int GATEWAY_CACHE_CAPACITY_DEFAULT_VALUE = 2000;
    private final T appCache;
    private final TenantConfigBean tenantConfigBean;
    private final ConfigurationProperties configProperties = new ConfigurationProperties();

    public TenantBeanImpl(TenantConfigBean tenantConfigBean, T appCache) {
        this.appCache = appCache;
        this.tenantConfigBean = tenantConfigBean;
    }

    public T getAppCache() {
        return this.appCache;
    }

    public String getSchemaName() {
        return this.tenantConfigBean.getSchemaName();
    }

    public String getEnvProperty(String propertyName) {
        return this.tenantConfigBean.getEnvProperty(propertyName);
    }

    public String getAccountsBaseUrl() {
        String accountsBaseUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_API_BASE_URL.name());
        return EnvironmentFactory.getEnvironment().getAccountsBaseUrl(accountsBaseUrl);
    }

    public String getAccountsLoginURL() {
        String accountsAuthUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.ACCOUNTS_AUTH_URL.name());
        return EnvironmentFactory.getEnvironment().getAccountsLoginURL(accountsAuthUrl);
    }

    public String getTenantId() {
        return this.tenantConfigBean.getEnvProperty(EnvironmentProperties.TENANT_ID.name());
    }

    public TenantConfigBean getTenantConfigBean() {
        return this.tenantConfigBean;
    }

    public String getTenantIdentifier() {
        return this.tenantConfigBean.getTenantIdentifier();
    }

    public String getAccountsOauthUrl() {
        String accountsBaseUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_UI_BASE_URL.name());
        return EnvironmentFactory.getEnvironment().getAccountsOauthUrl(accountsBaseUrl);
    }

    public String getLogoutUrl() {
        String accountsBaseUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_API_BASE_URL.name());
        return EnvironmentFactory.getEnvironment().getLogoutUrl(accountsBaseUrl);
    }

    public GatewayConfig getGatewayConfig(String authToken, String requestUrl) {
        GatewayConfig gatewayConfig = null;
        try {
            Map<String, String> configParams = this.getGatewayConfigParams();
            String tenantId = this.getTenantId();
            LOGGER.info((Object)("TenantId : " + tenantId));
            Environment env = EnvironmentFactory.getEnvironment();
            gatewayConfig = GatewayHelper.createGatewayConfig((ServiceType)env.getEnvConfigBean().getServiceType(), (String)tenantId, configParams);
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"gateway exception occurred while creating GatewayConfig", (Throwable)e);
        }
        return gatewayConfig;
    }

    public Map<String, String> getGatewayConfigParams() {
        HashMap<String, String> configParams = new HashMap<String, String>();
        configParams.put("ACCOUNT_ID_KEY", this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_ID.name()));
        configParams.put("ACCOUNT_GUID_KEY", this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_ACCOUNT_GUID.name()));
        configParams.put("ENV_GUID_KEY", this.tenantConfigBean.getEnvProperty(EnvironmentProperties.ENVIRONMENT_ID.name()));
        String accountsAuthUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.ACCOUNTS_AUTH_URL.name());
        configParams.put("ACCOUNTS_AUTH_URL", accountsAuthUrl);
        String trustAuthUrl = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.TRUST_AUTH_URL.name());
        configParams.put("TRUST_AUTH_URL", trustAuthUrl);
        configParams.put("IDENTITY_SESSION_TOKEN_CACHE_DURATION_MINS", this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_SERVER_IDENTITY_SESSION_TOKEN_CACHE_DURATION_MIN.name()));
        configParams.put("X-Kony-Service-To-Identity-Auth", this.tenantConfigBean.getEnvProperty(EnvironmentProperties.KONY_SERVER_TO_IDENTITY_AUTH_HEADER.name()));
        configParams.put("CONSUMER_KEY", this.tenantConfigBean.getEnvProperty("consumer_key"));
        configParams.put("CONSUMER_SECRET", this.tenantConfigBean.getEnvProperty("consumer_secret"));
        int cacheCapacityInt = this.getGatewayCacheCapacity();
        if (cacheCapacityInt > 0) {
            configParams.put("CACHE_CAPACITY", String.valueOf(cacheCapacityInt));
        } else {
            configParams.put("CACHE_CAPACITY", "-1");
        }
        LOGGER.info((Object)("Gateway version : " + MiddlewareMBaasUtils.getGatewayVersion()));
        LOGGER.info((Object)("GATEWAY_CACHE_CAPACITY : " + cacheCapacityInt));
        LOGGER.info((Object)("ACCOUNTS_AUTH_URL : " + accountsAuthUrl));
        LOGGER.info((Object)("TRUST_AUTH_URL : " + trustAuthUrl));
        return configParams;
    }

    public int getGatewayCacheCapacity() {
        String cacheCapacity = this.tenantConfigBean.getEnvProperty(EnvironmentProperties.GATEWAY_CACHE_CAPACITY.name());
        return NumberUtils.toInt((String)cacheCapacity, (int)2000);
    }

    public ConfigurationProperties getConfigurationProperties() {
        return this.configProperties;
    }

    public boolean equals(Object obj) {
        Boolean preCheck = EqualsHelper.preCheckEquals((Object)this, (Object)obj);
        if (preCheck != null) {
            return preCheck;
        }
        TenantBeanImpl other = (TenantBeanImpl)obj;
        return this.tenantConfigBean.getTenantIdentifier().equalsIgnoreCase(other.tenantConfigBean.getTenantIdentifier());
    }

    public int hashCode() {
        return this.tenantConfigBean.getTenantIdentifier().hashCode();
    }

    public String toString() {
        return this.tenantConfigBean.getTenantIdentifier();
    }

    TenantBean<T> clone(T appCache) {
        return new TenantBeanImpl<T>(this.tenantConfigBean, appCache);
    }

    public GatewayConfig getGatewayConfig(CacheDirector cacheDirector) {
        GatewayConfig gatewayConfig = null;
        try {
            Map<String, String> configParams = this.getGatewayConfigParams();
            String tenantId = this.getTenantId();
            LOGGER.info((Object)("TenantId : " + tenantId));
            Environment env = EnvironmentFactory.getEnvironment();
            gatewayConfig = GatewayHelper.createGatewayConfig((ServiceType)env.getEnvConfigBean().getServiceType(), (String)tenantId, configParams, (CacheDirector)cacheDirector);
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"gateway exception occurred while creating GatewayConfig", (Throwable)e);
        }
        return gatewayConfig;
    }
}

