/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.throttle;

import com.kony.mobilefabric.throttle.Throttle;
import com.kony.mobilefabric.throttle.ThrottleException;
import com.kony.mobilefabric.throttle.Throttles;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.utilities.MaskUtils;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class MWThrottle {
    private final String throttleName;
    private final boolean distributeUniformlyAcrossNodes;
    private final Throttle<String> throttle;
    private final Environment environment;
    private Integer designTimeLimit;
    private Integer runtimeLimit;

    public MWThrottle(String throttleName, boolean distributeUniformlyAcrossNodes, String exceptionMessageFormat) {
        this(throttleName, distributeUniformlyAcrossNodes, exceptionMessageFormat, EnvironmentFactory.getEnvironment());
    }

    protected MWThrottle(String throttleName, boolean distributeUniformlyAcrossNodes, String exceptionMessageFormat, Environment environment) {
        this.throttleName = throttleName;
        this.distributeUniformlyAcrossNodes = distributeUniformlyAcrossNodes;
        this.throttle = Throttles.newVariableLimit((String)exceptionMessageFormat, this::getLimit);
        this.environment = environment;
    }

    public void check(String identifier) throws ConnectorException {
        try {
            this.throttle.check((Object)identifier);
        }
        catch (ThrottleException se) {
            MaskUtils.maskTrace((String)se.getMessage(), (Throwable)se);
            throw new ConnectorException("", "14049", 429, se.getMessage());
        }
    }

    public void updateDesignTimeLimit(Map<String, String> config) {
        this.designTimeLimit = this.getLimitFromMap(config);
    }

    public void updateRuntimeLimit(Map<String, String> config) {
        this.runtimeLimit = this.getLimitFromMap(config);
    }

    int getLimit(String identifier) {
        int numberOfNodes = this.distributeUniformlyAcrossNodes ? this.getNumberOfNodes() : 1;
        int limit = -1;
        if (this.runtimeLimit != null) {
            limit = this.runtimeLimit / numberOfNodes;
        } else if (this.designTimeLimit != null) {
            limit = this.designTimeLimit / numberOfNodes;
        }
        return limit;
    }

    private int getNumberOfNodes() {
        return this.environment != null ? this.environment.getNumberOfNodes() : 1;
    }

    private Integer getLimitFromMap(Map<String, String> config) {
        String limitStr = config.get(this.throttleName);
        return StringUtils.isBlank((CharSequence)limitStr) ? null : Integer.valueOf(NumberUtils.toInt((String)limitStr, (int)-1));
    }
}

