/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.throttle;

import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.throttle.RunTimeConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class ThrottleUtil {
    public static final String TOTAL_RATE_LIMIT = "totalRateLimit";
    public static final String RATE_LIMIT_PER_IP = "rateLimitPerIP";

    public static void checkThrottled(ServiceMetadata serviceMeta, DataControllerRequest request) throws ConnectorException {
        ApplicationMetadata appMetadata = serviceMeta.getAppMetadata();
        appMetadata.getIpLimitThrottle().check(ThrottleUtil.getRemoteAddress(request));
        appMetadata.getTotalLimitThrottle().check(serviceMeta.getAppId());
    }

    public static Map<String, String> getMapFromConfig(RunTimeConfig runTimeConfig) {
        HashMap<String, String> map = new HashMap<String, String>();
        ThrottleUtil.writeProperty(map, TOTAL_RATE_LIMIT, runTimeConfig.getTotalRateLimit());
        ThrottleUtil.writeProperty(map, RATE_LIMIT_PER_IP, runTimeConfig.getRateLimitPerIP());
        return map;
    }

    public static Map<String, String> getMapFromConfig(List<ConfigParam> configParams) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ConfigParam cp : configParams) {
            if (RATE_LIMIT_PER_IP.equalsIgnoreCase(cp.getName())) {
                map.put(RATE_LIMIT_PER_IP, cp.getValue());
                continue;
            }
            if (!TOTAL_RATE_LIMIT.equalsIgnoreCase(cp.getName())) continue;
            map.put(TOTAL_RATE_LIMIT, cp.getValue());
        }
        return map;
    }

    public static Map<String, String> getMapFromConfig(Map<String, String> configMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (configMap != null) {
            for (Map.Entry<String, String> entry : configMap.entrySet()) {
                if (RATE_LIMIT_PER_IP.equalsIgnoreCase(entry.getKey())) {
                    map.put(RATE_LIMIT_PER_IP, entry.getValue());
                    continue;
                }
                if (!TOTAL_RATE_LIMIT.equalsIgnoreCase(entry.getKey())) continue;
                map.put(TOTAL_RATE_LIMIT, entry.getValue());
            }
        }
        return map;
    }

    static String getRemoteAddress(DataControllerRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress == null) {
            ipAddress = "";
        }
        return ipAddress;
    }

    private static void writeProperty(Map<String, String> map, String propertyName, String propertyValue) {
        if (StringUtils.isBlank((String)propertyValue)) {
            propertyValue = "";
        }
        map.put(propertyName, propertyValue);
    }

    private ThrottleUtil() {
    }
}

