/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.EnvironmentDao;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.common.TimerProperties;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterUtil;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.impl.AmazonMobileFabricEnvironment;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.KonyTimer;
import com.konylabs.middleware.timer.TimerDataObject;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class AbstractKonyTimer
extends TimerTask
implements KonyTimer {
    private static final Logger LOGGER = Logger.getLogger(AbstractKonyTimer.class);
    protected Map<String, Timestamp> lastUpdatedDates = new ConcurrentHashMap<String, Timestamp>();
    protected Map<String, Object> lastUpdatedAssets = new ConcurrentHashMap<String, Object>();
    protected String timerTaskName;
    protected EnvironmentConfigBean environmentConfigBean = null;
    protected WritableTenantEnvManager tenantEnvManager;
    private boolean timerActive = false;

    public AbstractKonyTimer(EnvironmentConfigBean environmentConfigBean, WritableTenantEnvManager tenantEnvManager) {
        this.environmentConfigBean = environmentConfigBean;
        this.tenantEnvManager = tenantEnvManager;
    }

    public boolean isEnvironmentRegistered(EnvironmentConfigBean envConfigBean) throws Exception {
        return ((EnvironmentDao)DAOFactory.getDAO(EnvironmentDao.class)).isEnvironmentRegistered(envConfigBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.timerActive) {
            Date startTime = null;
            try {
                this.timerActive = true;
                startTime = new Date();
                LOGGER.trace((Object)("Timer task " + this.timerTaskName + " started"));
                this.performTimerUpdateTask();
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unable to load the configuration from database", (Throwable)e);
            }
            finally {
                this.timerActive = false;
                LOGGER.trace((Object)("Timer task " + this.timerTaskName + " completed"));
                Date endTime = new Date();
                long timerPeriod = (Long)TimerProperties.TIMER_PERIOD.getFromConfig();
                if (endTime.getTime() - startTime.getTime() > timerPeriod) {
                    LOGGER.debug((Object)("Timer task " + this.timerTaskName + " processing time :" + (endTime.getTime() - startTime.getTime())));
                }
            }
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void performTimerUpdateTask() throws Exception {
        if (!TenantUtilities.isMultiTenant()) {
            boolean isEnvironmentEntryFound = this.isEnvironmentRegistered(this.environmentConfigBean);
            TenantUtilities.reloadConfiguration();
            if (TenantUtilities.isEnvReloadRequired(isEnvironmentEntryFound)) {
                EnvironmentFactory.reloadEnvironment(this.environmentConfigBean);
                this.tenantEnvManager.loadTenantBean(this.getSingleTenantIdentifier());
                MiddlewareClassloaderManager classLoaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
                classLoaderManager.getMiddlewareResourceLookup().addResource(ConfigurationProperties.class, this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(this.getSingleTenantIdentifier()).getConfigurationProperties());
            }
            this.reloadNumberOfNodesForOnlyCloud();
        }
    }

    protected String getSingleTenantIdentifier() {
        Set tenantIdentifierKeys = this.tenantEnvManager.getReadableTenantEnvManager().getActiveTenants();
        return tenantIdentifierKeys.isEmpty() ? null : (String)tenantIdentifierKeys.iterator().next();
    }

    private void reloadNumberOfNodesForOnlyCloud() {
        Environment environment = EnvironmentFactory.getEnvironment();
        if (environment instanceof AmazonMobileFabricEnvironment) {
            ((AmazonMobileFabricEnvironment)environment).reloadNumberOfNodes();
        }
    }

    protected void putTimeStamp(String timeKey, Timestamp updatedTimestamp) {
        if (updatedTimestamp != null) {
            this.lastUpdatedDates.put(timeKey, updatedTimestamp);
        }
    }

    protected Timestamp getLastUpdatedTimeStamp(String timeKey) {
        Timestamp updatedTime = this.lastUpdatedDates.get(timeKey);
        if (updatedTime == null) {
            updatedTime = new Timestamp(-1L);
            this.putTimeStamp(timeKey, updatedTime);
        }
        return updatedTime;
    }

    public String getTimerTaskName() {
        return this.timerTaskName;
    }

    public void setTimerTaskName(String timerTaskName) {
        this.timerTaskName = timerTaskName;
    }

    protected void setServicesTimeStamp(String tenantEnvKey, Timestamp date) {
        this.putTimeStamp(tenantEnvKey + "services_time_stamp", date);
    }

    protected void setNotificationTimeStamp(String tenantEnvKey, Timestamp timestamp) {
        LOGGER.debug((Object)("Updating the last notification timestamp in timer cache to " + timestamp));
        this.putTimeStamp(tenantEnvKey + "notification_time_stamp", timestamp);
    }

    protected Timestamp getServicesLastUpdatedTimeStamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "services_time_stamp");
    }

    protected void setJarsTimeStamp(String tenantEnvKey, Timestamp date) {
        this.putTimeStamp(tenantEnvKey + "jars_time_stamp", date);
    }

    protected Timestamp getJarsLastUpdatedTimeStamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "jars_time_stamp");
    }

    protected Timestamp getNotificationsLastUpdatedTimeStamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "notification_time_stamp");
    }

    protected List<AppVersion> getLoadedServiceIds(String tenantEnvKey) {
        return (List)this.lastUpdatedAssets.get(tenantEnvKey + "service_id_store_key");
    }

    protected void saveJarsUpdatedTimeAndJarsInDb(String tenantEnvKey, TimerDataObject timerDataObject) {
        if (timerDataObject != null && timerDataObject.getDate() != null && timerDataObject.getJarIdsList() != null) {
            this.setJarsTimeStamp(tenantEnvKey, timerDataObject.getDate());
            this.lastUpdatedAssets.put(tenantEnvKey + "jar_id_store_key", timerDataObject.getJarIdsList());
        }
    }

    protected void saveServiceUpdatedTimeAndServicesInDb(String tenantEnvKey, TimerDataObject timerDataObject) {
        if (timerDataObject != null && timerDataObject.getDate() != null) {
            this.setServicesTimeStamp(tenantEnvKey, timerDataObject.getDate());
            this.lastUpdatedAssets.remove(tenantEnvKey + "service_id_store_key");
            this.lastUpdatedAssets.remove(tenantEnvKey + "asset_id_store_key");
            this.lastUpdatedAssets.put(tenantEnvKey + "service_id_store_key", timerDataObject.getServicesList());
            Map<AppVersion, List<AssetType>> assetTypeListMap = timerDataObject.getAssetTypeMap();
            this.lastUpdatedAssets.put(tenantEnvKey + "asset_id_store_key", assetTypeListMap);
        }
    }

    protected List<String> getLoadedJarIds(String tenantEnvKey) {
        return (List)this.lastUpdatedAssets.get(tenantEnvKey + "jar_id_store_key");
    }

    protected Map<AppVersion, List<AssetType>> getLoadedAssetIds(String tenantEnvKey) {
        return (Map)this.lastUpdatedAssets.get(tenantEnvKey + "asset_id_store_key");
    }

    protected void saveAppConfigUpdatedTime(String tenantEnvKey, Timestamp timestamp) {
        this.putTimeStamp(tenantEnvKey + "app_config_time_stamp", timestamp);
    }

    protected Timestamp getAppConfigLastUpdatedTimeStamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "app_config_time_stamp");
    }

    protected TimerDataObject getLoadedServiceIdsAndAssetTypes(String tenantEnvKey) {
        List<AppVersion> loadedServiceIds = this.getLoadedServiceIds(tenantEnvKey);
        Map<AppVersion, List<AssetType>> assetTypeMap = this.getLoadedAssetIds(tenantEnvKey);
        Timestamp servicesLastUpdatedTimeStamp = this.getServicesLastUpdatedTimeStamp(tenantEnvKey);
        return new TimerDataObject(null, loadedServiceIds, servicesLastUpdatedTimeStamp, assetTypeMap);
    }

    protected void setConfigServicesTimeStamp(String tenantEnvKey, Timestamp lastUpdatedTimestamp) {
        this.putTimeStamp(tenantEnvKey + "config_services_time_key", lastUpdatedTimestamp);
    }

    protected Timestamp getConfigServicesLastUpdatedTimeStamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "config_services_time_key");
    }

    protected Timestamp getUserCertsLastUpdatedTimestamp(String tenantEnvKey) {
        return this.getLastUpdatedTimeStamp(tenantEnvKey + "user_certs_key");
    }

    protected void setUserCertsLastUpdatedTimestamp(Timestamp lastUpdatedTimestamp, String tenantEnvKey) {
        this.putTimeStamp(tenantEnvKey + "user_certs_key", lastUpdatedTimestamp);
    }

    protected void initializeAdapterAndClearDataAdapterCache(AppCache appCache, DataAdapterCache dataAdapterCache) {
        if (appCache != null) {
            try {
                DataAdapterUtil.performAdapterIntialization(appCache, dataAdapterCache);
                dataAdapterCache.clearUpdatedServicesCache();
            }
            catch (Error error) {
                dataAdapterCache.clearUpdatedServicesCache();
                LOGGER.error((Object)"Unexpected error while initializing adapter", (Throwable)error);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unexpected error while initializing adapter", (Throwable)e);
            }
        }
    }
}

