/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.service.MultiTimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.AbstractKonyTimer;
import com.konylabs.middleware.timer.TimerDataObject;
import com.konylabs.middleware.timer.TimerUtils;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class KonyIntegrationMultiTenantTimer
extends AbstractKonyTimer {
    private static final Logger LOGGER = Logger.getLogger(KonyIntegrationMultiTenantTimer.class);
    private final int threadCount = ConfigUtility.getIntProperty((String)"KONY_SERVER_TIMER_TENANT_BACKGROUND_THREADS", (int)10);
    private final long timeout = ConfigUtility.getLongProperty((String)"TIMER_THREAD_TIMEOUT", (long)5L);
    private final ExecutorService executor = Executors.newFixedThreadPool(this.threadCount);
    private final List<Future<Void>> previousFutures = new ArrayList<Future<Void>>();

    public KonyIntegrationMultiTenantTimer(EnvironmentConfigBean environmentConfigBean, WritableTenantEnvManager tenantEnvManager) throws SQLException {
        super(environmentConfigBean, tenantEnvManager);
    }

    @Override
    public void performTimerUpdateTask() {
        TimerUtils.waitForPreviousThreadsToComplete(this.previousFutures);
        try {
            Set tenantIdentifiers = this.tenantEnvManager.getReadableTenantEnvManager().getActiveTenants();
            LOGGER.debug((Object)("List of active tenants : " + tenantIdentifiers));
            Set<Callable<Void>> callables = this.getCallablesList(tenantIdentifiers);
            this.previousFutures.addAll(this.executor.invokeAll(callables, this.timeout, TimeUnit.MINUTES));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred in Timer ", (Throwable)e);
        }
    }

    protected Set<Callable<Void>> getCallablesList(Set<String> tenantIdentifiers) throws TenantException {
        HashSet<Callable<Void>> callables = new HashSet<Callable<Void>>();
        for (String tenantIdentifier : tenantIdentifiers) {
            String schemaName = this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(tenantIdentifier).getSchemaName();
            callables.add(new TimerThread(tenantIdentifier, schemaName));
        }
        return callables;
    }

    private class TimerThread
    implements Callable<Void> {
        private String tenantIdentifier;
        private String schemaName;

        public TimerThread(String tenantIdentifier, String schemaName) {
            this.tenantIdentifier = tenantIdentifier;
            this.schemaName = schemaName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOGGER.debug((Object)String.format("Started the timer process for the tenant with tenant identifier : %s", this.tenantIdentifier));
            MultiTimerCacheUpdateService timerCacheUpdateService = new MultiTimerCacheUpdateService(KonyIntegrationMultiTenantTimer.this.tenantEnvManager, this.tenantIdentifier, this.schemaName);
            TimerDataObject timerDataObject = KonyIntegrationMultiTenantTimer.this.getLoadedServiceIdsAndAssetTypes(this.tenantIdentifier);
            AppCache appCache = null;
            DataAdapterCache dataAdapterCache = new DataAdapterCache();
            try {
                appCache = (AppCache)KonyIntegrationMultiTenantTimer.this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(this.tenantIdentifier).getAppCache();
                TimerDataObject totalServicesInDbWithTime = timerCacheUpdateService.reloadUpdateServicesAndRemoveDeletedServices(timerDataObject, dataAdapterCache);
                KonyIntegrationMultiTenantTimer.this.saveServiceUpdatedTimeAndServicesInDb(this.tenantIdentifier, totalServicesInDbWithTime);
                appCache.getFrontendResourceIdentifier().getResourceIdentifierBuilder().build();
            }
            catch (Throwable e) {
                try {
                    LOGGER.error((Object)("error occurred while loading apps and assets with tenant identifier: " + this.tenantIdentifier), e);
                }
                catch (Throwable throwable) {
                    KonyIntegrationMultiTenantTimer.this.initializeAdapterAndClearDataAdapterCache(appCache, dataAdapterCache);
                    throw throwable;
                }
                KonyIntegrationMultiTenantTimer.this.initializeAdapterAndClearDataAdapterCache(appCache, dataAdapterCache);
            }
            KonyIntegrationMultiTenantTimer.this.initializeAdapterAndClearDataAdapterCache(appCache, dataAdapterCache);
            return null;
        }
    }
}

