/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.NodeNotifierDAO;
import com.kony.middleware.dbcommons.dao.NodeStatusDAO;
import com.kony.middleware.dbcommons.entity.NodeInfo;
import com.kony.middleware.dbcommons.entity.TimerNotification;
import com.konylabs.middleware.connectors.DefaultSSLContextFactory;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.exceptions.MiddlewareDbException;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.service.DbTimerCacheUpdateServiceImpl;
import com.konylabs.middleware.service.TimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.AbstractKonyTimer;
import com.konylabs.middleware.timer.TimerActions;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.TimestampUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class KonyNotificationTimerImpl
extends AbstractKonyTimer {
    private static final Logger LOGGER = Logger.getLogger(KonyNotificationTimerImpl.class);
    private NodeStatusDAO nodeStatusDAO = (NodeStatusDAO)DAOFactory.getDAO(NodeStatusDAO.class);
    private NodeNotifierDAO nodeNotifierDAO = (NodeNotifierDAO)DAOFactory.getDAO(NodeNotifierDAO.class);

    public KonyNotificationTimerImpl(EnvironmentConfigBean ecb, WritableTenantEnvManager tenantManager) throws SQLException {
        super(ecb, tenantManager);
    }

    @Override
    public void initialize() {
        String singleTenantIdentifier = this.getSingleTenantIdentifier();
        DbTimerCacheUpdateServiceImpl timerCacheUpdateService = new DbTimerCacheUpdateServiceImpl(this.tenantEnvManager, singleTenantIdentifier);
        DataAdapterCache dataAdapterCache = new DataAdapterCache();
        try {
            AppCache konyAppCache = (AppCache)this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(singleTenantIdentifier).getAppCache();
            Timestamp lastNotificationTime = this.nodeNotifierDAO.getLastNotificationTimeStamp();
            LOGGER.debug((Object)"Loading all the services into cache");
            timerCacheUpdateService.loadAllServices(dataAdapterCache);
            this.setNotificationTimeStamp(singleTenantIdentifier, lastNotificationTime);
            this.reloadJarsAndUpdateResourceTracerAndInitializeDataAdapter(dataAdapterCache, konyAppCache, timerCacheUpdateService);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occured while loading all the services from db", (Throwable)e);
        }
    }

    @Override
    public void performTimerUpdateTask() {
        LOGGER.debug((Object)"-----------------------------------------------Timer Started----------------------------------------------");
        try {
            super.performTimerUpdateTask();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while updating environment ", (Throwable)e);
        }
        String singleTenantIdentifier = this.getSingleTenantIdentifier();
        DataAdapterCache dataAdapterCache = new DataAdapterCache();
        AppCache konyAppCache = null;
        DbTimerCacheUpdateServiceImpl timerCacheUpdateService = new DbTimerCacheUpdateServiceImpl(this.tenantEnvManager, singleTenantIdentifier);
        try {
            konyAppCache = (AppCache)this.tenantEnvManager.getReadableTenantEnvManager().getTenantBean(singleTenantIdentifier).getAppCache();
            String nodeId = ConfigUtility.getProperty((String)"kony_server_node_id");
            LOGGER.debug((Object)("Publish timer started in nodeId: " + nodeId));
            NodeInfo nodeInfo = this.nodeStatusDAO.getNodeInfo(nodeId);
            if (nodeInfo != null && !nodeInfo.getIsPublishTimerDisabled()) {
                TimerNotification timerNotification = this.nodeNotifierDAO.getNotification(this.getNotificationsLastUpdatedTimeStamp(singleTenantIdentifier));
                if (timerNotification != null) {
                    try {
                        LOGGER.debug((Object)("Found Notification with action " + timerNotification.getAction()));
                        LOGGER.debug((Object)String.format("Details of the Notification: notificationId -> %d, processid -> %d, updated_date -> %s", timerNotification.getId(), timerNotification.getProcessId(), timerNotification.getUpdatedDate()));
                        if (TimerActions.SERVICES_DELETE.name().equals(timerNotification.getAction())) {
                            LOGGER.debug((Object)("Initiating services delete from cache for services in process " + timerNotification.getProcessId()));
                            timerCacheUpdateService.deleteServices(timerNotification, singleTenantIdentifier, dataAdapterCache);
                            this.reloadJarsAndUpdateResourceTracerAndInitializeDataAdapter(dataAdapterCache, konyAppCache, timerCacheUpdateService);
                            this.updateNodeProcessStatus(nodeInfo, timerNotification.getProcessId(), timerNotification.getAction(), "completed", null);
                        } else if (TimerActions.SERVICES_PUBLISH.name().equals(timerNotification.getAction())) {
                            LOGGER.debug((Object)("Initiating services load into cache for services in process " + timerNotification.getProcessId()));
                            timerCacheUpdateService.loadServices(timerNotification, dataAdapterCache, this.getNotificationsLastUpdatedTimeStamp(singleTenantIdentifier));
                            this.reloadJarsAndUpdateResourceTracerAndInitializeDataAdapter(dataAdapterCache, konyAppCache, timerCacheUpdateService);
                            this.updateNodeProcessStatus(nodeInfo, timerNotification.getProcessId(), timerNotification.getAction(), "completed", null);
                        } else if (TimerActions.HEALTH_CHECK.name().equals(timerNotification.getAction())) {
                            LOGGER.debug((Object)("Acknowledging health check notification with process id " + timerNotification.getProcessId()));
                            nodeInfo.setHealthAcknowledge(timerNotification.getProcessId());
                            this.nodeStatusDAO.updateNodeInfo(nodeInfo);
                        }
                        this.setNotificationTimeStamp(singleTenantIdentifier, timerNotification.getUpdatedDate());
                        LOGGER.debug((Object)String.format("Finished processing notification %d with process id %d and action %s", timerNotification.getId(), timerNotification.getProcessId(), timerNotification.getAction()));
                    }
                    catch (Throwable t) {
                        LOGGER.error((Object)("Error occurred while executing action" + timerNotification.getAction() + " for process" + timerNotification.getProcessId()), t);
                        this.updateNodeProcessStatus(nodeInfo, timerNotification.getProcessId(), timerNotification.getAction(), "failed", t.getMessage());
                    }
                } else {
                    LOGGER.debug((Object)"No new notifications found");
                }
            } else {
                LOGGER.debug((Object)"Publish timer is disabled for this node");
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"error occurred while loading apps and assets", e);
        }
        try {
            Timestamp configServerTimestamp = this.getAppConfigLastUpdatedTimeStamp(singleTenantIdentifier);
            Timestamp configLastReloadedTimestamp = timerCacheUpdateService.loadAllAppConfigFromDatabase(configServerTimestamp);
            Timestamp updatedConfigLastReloadTimestamp = TimestampUtils.incrementByOneSecIfNeeded((Timestamp)configServerTimestamp, (Timestamp)configLastReloadedTimestamp);
            this.saveAppConfigUpdatedTime(singleTenantIdentifier, updatedConfigLastReloadTimestamp);
            Timestamp configServicesServerTimeStamp = this.getConfigServicesLastUpdatedTimeStamp(singleTenantIdentifier);
            Timestamp configServicesLastReloadedTimestamp = timerCacheUpdateService.reloadUpdatedConfigServiceParams(configServicesServerTimeStamp);
            Timestamp updatedConfigServicesLastReloadTimestamp = TimestampUtils.incrementByOneSecIfNeeded((Timestamp)configServicesServerTimeStamp, (Timestamp)configServicesLastReloadedTimestamp);
            this.setConfigServicesTimeStamp(singleTenantIdentifier, updatedConfigServicesLastReloadTimestamp);
            Timestamp certsServerTimestamp = this.getUserCertsLastUpdatedTimestamp(singleTenantIdentifier);
            Timestamp certsLastReloadedTimestamp = null;
            int countOfCerts = DefaultSSLContextFactory.getServerCertificates().size();
            if (timerCacheUpdateService.isServerCertsUpdated(certsServerTimestamp, countOfCerts)) {
                certsLastReloadedTimestamp = timerCacheUpdateService.reloadHttpClientWithCerts();
            }
            Timestamp updatedCertsLastReloadTimestamp = TimestampUtils.incrementByOneSecIfNeeded((Timestamp)certsServerTimestamp, (Timestamp)certsLastReloadedTimestamp);
            this.setUserCertsLastUpdatedTimestamp(updatedCertsLastReloadTimestamp, singleTenantIdentifier);
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Error occurred in Timer ", e);
        }
        LOGGER.debug((Object)"----------------------------------------------Timer Finished---------------------------------------------");
    }

    private void reloadJarsAndUpdateResourceTracerAndInitializeDataAdapter(DataAdapterCache dataAdapterCache, AppCache konyAppCache, TimerCacheUpdateService timerCacheUpdateService) throws MiddlewareDbException, IOException, SQLException, MiddlewareException {
        LOGGER.debug((Object)"Initializing resource tracer");
        konyAppCache.getFrontendResourceIdentifier().getResourceIdentifierBuilder().build();
        this.reloadJarsSilently(dataAdapterCache, timerCacheUpdateService);
        this.initializeAdapterAndClearDataAdapterCache(konyAppCache, dataAdapterCache);
    }

    private void reloadJarsSilently(DataAdapterCache dataAdapterCache, TimerCacheUpdateService timerCacheUpdateService) {
        LOGGER.debug((Object)"Reloading classloader");
        try {
            timerCacheUpdateService.reloadJars();
            dataAdapterCache.setJarRefresh(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error in loading jars", (Throwable)e);
        }
    }

    private void updateNodeProcessStatus(NodeInfo nodeInfo, long processId, String processAction, String processStatus, String errorMsg) throws SQLException {
        nodeInfo.setProcessId(processId);
        nodeInfo.setProcessAction(processAction);
        nodeInfo.setProcessStatus(processStatus);
        if (errorMsg != null) {
            nodeInfo.setErrorMsg(errorMsg);
        }
        this.nodeStatusDAO.updateNodeInfo(nodeInfo);
    }
}

