/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.service.AbstractTimerCacheUpdateService;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.AbstractKonyTimer;
import com.konylabs.middleware.timer.KonyIntegrationMultiTenantTimer;
import com.konylabs.middleware.timer.KonyNotificationTimerImpl;
import com.konylabs.middleware.timer.KonyWebAppTimer;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.sql.SQLException;

public class KonyTimerFactory {
    public static AbstractKonyTimer getTimer(String thisAppType, EnvironmentConfigBean configBean, WritableTenantEnvManager tenantManager, AbstractTimerCacheUpdateService mobileFabricService) throws MiddlewareException, IOException {
        AbstractKonyTimer abstractKonyTimer = null;
        try {
            if (TenantUtilities.isMultiTenant()) {
                abstractKonyTimer = new KonyIntegrationMultiTenantTimer(configBean, tenantManager);
            } else {
                mobileFabricService.reloadJars();
                abstractKonyTimer = new KonyNotificationTimerImpl(configBean, tenantManager);
            }
            abstractKonyTimer = Boolean.parseBoolean(thisAppType) ? abstractKonyTimer : new KonyWebAppTimer(configBean, tenantManager);
            abstractKonyTimer.initialize();
            return abstractKonyTimer;
        }
        catch (SQLException e) {
            throw new MiddlewareException(null, null, (Throwable)e);
        }
    }
}

