/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.konylabs.middleware.common.TimerProperties;
import com.konylabs.middleware.timer.AbstractKonyTimer;
import com.konylabs.middleware.timer.KonyTimerBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class KonyTimerScheduler {
    private static final Logger LOGGER = Logger.getLogger(KonyTimerScheduler.class);
    private final Map<String, KonyTimerBean> timerBeanMap = new HashMap<String, KonyTimerBean>();
    private static KonyTimerScheduler konyTimerScheduler;

    private KonyTimerScheduler() {
    }

    public static KonyTimerScheduler getInstance() {
        if (konyTimerScheduler == null) {
            LOGGER.debug((Object)"Creating new instance of KonyTimerScheduler.");
            konyTimerScheduler = new KonyTimerScheduler();
        }
        return konyTimerScheduler;
    }

    public void stopTimer(String timerName) {
        LOGGER.debug((Object)("Stopping timer " + timerName));
        KonyTimerBean timerBean = this.timerBeanMap.get(timerName);
        if (timerBean != null) {
            if (timerBean.getTimer() != null) {
                timerBean.getTimer().cancel();
                timerBean.getTimer().purge();
            }
            if (timerBean.getTimerTask() != null) {
                timerBean.getTimerTask().cancel();
            }
        }
    }

    public void scheduleTimer(String timerName, AbstractKonyTimer konyBasicTimer) {
        Timer timer = new Timer();
        KonyTimerBean timerBean = new KonyTimerBean(timer, konyBasicTimer);
        konyBasicTimer.setTimerTaskName(timerName);
        long delay = (Long)TimerProperties.TIMER_DELAY.getFromConfig();
        long timerPeriod = (Long)TimerProperties.TIMER_PERIOD.getFromConfig();
        timer.schedule((TimerTask)konyBasicTimer, delay, timerPeriod);
        LOGGER.debug((Object)("Started the Scheduler " + timerName));
        this.timerBeanMap.put(timerName, timerBean);
    }
}

