/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.timer;

import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.service.DbTimerCacheUpdateServiceImpl;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.KonyTimerFactory;
import com.konylabs.middleware.timer.KonyTimerScheduler;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class TimerUtils {
    private static final Logger LOGGER = Logger.getLogger(TimerUtils.class);

    private TimerUtils() {
    }

    public static void createBackgroundTimerAndRun(WritableTenantEnvManager tenantEnvManager, EnvironmentConfigBean configBean, String isServices, String contextPath) {
        try {
            DbTimerCacheUpdateServiceImpl mobileFabricService = new DbTimerCacheUpdateServiceImpl(tenantEnvManager);
            LOGGER.info((Object)"Scheduling Server Timer");
            KonyTimerScheduler scheduler = KonyTimerScheduler.getInstance();
            if (scheduler != null) {
                String timerName = contextPath;
                scheduler.scheduleTimer(timerName, KonyTimerFactory.getTimer(isServices, configBean, tenantEnvManager, mobileFabricService));
                LOGGER.info((Object)("Successfully started the Kony Timer Scheduler :" + timerName));
            } else {
                LOGGER.error((Object)"FATAL ERROR : Please check the Kony Timer Scheduler Settings");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while scheduling timer", (Throwable)e);
        }
    }

    public static void waitForPreviousThreadsToComplete(List<Future<Void>> futures) {
        LOGGER.debug((Object)"Waiting for the previously spanned threads to complete.");
        for (Future<Void> future : futures) {
            LOGGER.debug((Object)("Completion status : " + future.isDone()));
        }
        futures.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBlobToFile(Blob fileBlob, String folderName, String fileName) throws SQLException, IOException {
        LOGGER.debug((Object)String.format("Copying jar %s to folder %s from blob data", fileName, folderName));
        InputStream inputStream = null;
        FileOutputStream fos = null;
        try {
            inputStream = fileBlob.getBinaryStream();
            if (!MiddlewareUtils.isDirPathValid(folderName)) {
                LOGGER.error((Object)("Invalid jars file path " + folderName));
                throw new IOException("Path manipulation - folder path contains malicious text " + folderName);
            }
            if (!MiddlewareUtils.isFilePathValid(fileName)) {
                LOGGER.error((Object)("Invalid file name " + fileName));
                throw new IOException("Path manipulation - file name contains malicious text " + fileName);
            }
            File file = new File(folderName);
            LOGGER.debug((Object)String.format("Created jar module directory [%s] : [%s]", folderName, file.mkdir()));
            fos = new FileOutputStream(folderName + fileName);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
            LOGGER.debug((Object)String.format("Finished copying jar %s to folder %s from blob data", fileName, folderName));
        }
        catch (Throwable throwable) {
            Closer.closeQuietly((Closeable)inputStream);
            Closer.closeQuietly(fos);
            throw throwable;
        }
        Closer.closeQuietly((Closeable)inputStream);
        Closer.closeQuietly((Closeable)fos);
    }
}

