/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tool;

import com.konylabs.jsonpath.JsonUtil;
import com.konylabs.middleware.common.Closer;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Writer;

public class RecordingResponseWriter
extends PrintWriter {
    private PrintWriter responseWriter;

    public RecordingResponseWriter(Writer writer, PrintWriter responseWriter) {
        super(writer);
        this.responseWriter = responseWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int offset, int length) {
        try {
            super.write(string, offset, length);
            this.writeToResponseFile(string, offset);
        }
        catch (Throwable throwable) {
            Closer.closeAllQuietly((Closeable[])new Closeable[]{this.responseWriter});
            throw throwable;
        }
        Closer.closeAllQuietly((Closeable[])new Closeable[]{this.responseWriter});
    }

    public void writeToResponseFile(String string, int offset) {
        String prettyJson = JsonUtil.getPrettyJsonIfValid(string);
        this.responseWriter.write(prettyJson, offset, prettyJson.length());
    }
}

