/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.tool;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.jsonpath.JsonUtil;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareIOUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class RecordingUtils {
    private static final Logger LOGGER = Logger.getLogger(RecordingUtils.class);
    public static final String RAW_JSON = "rawJson";

    private RecordingUtils() {
    }

    public static String prepareRequest(ServletRequest request, RequestData requestData) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        JsonObject inputMetadata = new JsonObject();
        JsonObject testMetadata = new JsonObject();
        testMetadata.addProperty("httpMethod", httpServletRequest.getMethod());
        testMetadata.addProperty("requestURL", httpServletRequest.getRequestURI());
        String queryString = httpServletRequest.getQueryString();
        if (queryString != null) {
            testMetadata.addProperty("queryString", queryString);
        }
        inputMetadata.add("testMetadata", (JsonElement)testMetadata);
        JsonObject rawJson = (JsonObject)requestData.getParam(RAW_JSON);
        if (rawJson != null) {
            RecordingUtils.removeNotRequiredProperties(rawJson);
            inputMetadata.add("payload", (JsonElement)rawJson);
        } else {
            String requestPayload = RecordingUtils.getPayloadFromRequestBodyAndParams(httpServletRequest, queryString);
            if (StringUtils.isNotBlank((String)requestPayload)) {
                inputMetadata.addProperty("payload", requestPayload);
            }
        }
        return inputMetadata.toString();
    }

    private static String getPayloadFromRequestBodyAndParams(HttpServletRequest httpServletRequest, String queryString) {
        Gson gson = new Gson();
        Map paramMap = httpServletRequest.getParameterMap();
        if (paramMap == null) {
            return null;
        }
        JsonObject json = (JsonObject)new JsonParser().parse(gson.toJson((Object)paramMap));
        if (queryString != null) {
            for (String parameter : queryString.split("&")) {
                String[] keyValue = parameter.split("=");
                if (keyValue.length != 2) continue;
                json.remove(keyValue[0]);
            }
        }
        RecordingUtils.removeNotRequiredProperties(json);
        return RecordingUtils.convertJsonToKeyValuePair(json);
    }

    public static void removeNotRequiredProperties(JsonObject payload) {
        payload.remove("appID");
        payload.remove("serviceID");
        payload.remove("channel");
    }

    public static String convertJsonToKeyValuePair(JsonObject json) {
        StringBuilder keyValueString = new StringBuilder();
        for (Map.Entry entry : json.entrySet()) {
            if (keyValueString.length() > 0) {
                keyValueString.append("&");
            }
            keyValueString.append((String)entry.getKey()).append("=").append(((JsonElement)entry.getValue()).getAsString());
        }
        return keyValueString.toString();
    }

    public static void writeDataToFile(String dataToWrite, String filePath, String extension) throws IOException {
        File file = MiddlewareIOUtils.getFileForFileNameAndExtension(filePath, extension);
        if (file.exists()) {
            LOGGER.debug((Object)"Request already recorded, so skipping writing to file");
            return;
        }
        file.createNewFile();
        LOGGER.debug((Object)("Writing data to file " + file.getPath()));
        FileUtils.writeStringToFile((File)file, (String)dataToWrite.toString());
    }

    public static String recordRequestAndReturnFilePath(ServletRequest request) throws IOException {
        RequestData requestData = (RequestData)request.getAttribute("requestdata");
        String requestDataToRecord = RecordingUtils.prepareRequest(request, requestData);
        String hashCode = String.valueOf(requestDataToRecord.hashCode());
        String filePath = RecordingUtils.getRecordFolderPathByRequestData(requestData, hashCode);
        RecordingUtils.writeDataToFile(JsonUtil.getPrettyJsonIfValid(requestDataToRecord), filePath, "_inputs.json");
        return filePath;
    }

    public static String getFileNameToWriteRequestAndResponse(String hashCode, RequestData requestData, StringBuilder serviceIdOrObjectID) {
        return MiddlewareUtils.sanitizeFolderName(requestData.getAppId()) + "_" + MiddlewareUtils.sanitizeFolderName(serviceIdOrObjectID.toString()) + "_" + hashCode;
    }

    public static String getRecordFolderPathByRequestData(RequestData requestData, String hashCode) {
        StringBuilder serviceIdOrObjectID = new StringBuilder();
        StringBuilder folderPath = new StringBuilder();
        folderPath.append(RecordingUtils.getRecordFileLocation());
        folderPath.append(File.separatorChar);
        folderPath.append(MiddlewareUtils.sanitizeFolderName(requestData.getAppId()));
        folderPath.append(File.separatorChar);
        if (StringUtils.isNotBlank((String)requestData.getServiceId())) {
            folderPath.append(MiddlewareUtils.sanitizeFolderName(requestData.getServiceId()));
            serviceIdOrObjectID.append(requestData.getServiceId());
        } else {
            if (requestData.getParam("objectID") != null) {
                String objectId = (String)requestData.getParam("objectID");
                objectId = MiddlewareUtils.sanitizeFolderName(objectId);
                folderPath.append(objectId);
                folderPath.append(File.separatorChar);
                serviceIdOrObjectID.append(objectId);
                serviceIdOrObjectID.append("_");
            }
            folderPath.append(requestData.getRequestedMethod());
            serviceIdOrObjectID.append(requestData.getRequestedMethod());
        }
        folderPath.append(File.separatorChar);
        folderPath.append(RecordingUtils.getFileNameToWriteRequestAndResponse(hashCode, requestData, serviceIdOrObjectID));
        folderPath.append(File.separatorChar);
        folderPath.append(RecordingUtils.getFileNameToWriteRequestAndResponse(hashCode, requestData, serviceIdOrObjectID));
        return folderPath.toString();
    }

    private static String getRecordFileLocation() {
        String defaultLocation = ConfigUtility.getProperty((String)"user.home");
        return ConfigUtility.getProperty((String)"RECORD_FILE_LOCATION", (String)defaultLocation) + File.separatorChar + "RecordedFiles";
    }
}

