/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.utilities;

import com.konylabs.commons.annotations.KonyContext;
import com.konylabs.commons.annotations.OnException;
import com.konylabs.middleware.api.ContextParams;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class AnnotationUtils {
    private static final Logger LOGGER = Logger.getLogger(AnnotationUtils.class);
    public static final String KONYCONTEXT_PARAMETER_METHOD_NAME = "parameterName";

    public static Result callPostProcessorOnException(DataControllerRequest request, DataControllerResponse response, Map<String, Object> configMap, Result result, Map<String, Object> inputMap, Exception exception) throws ConnectorException {
        Map<Class<?>, Object> contextMap = AnnotationUtils.prepareContext(request, response, inputMap, result, exception);
        Map<ContextParams, Object> mapByParamName = AnnotationUtils.prepareContextWithParamName(request, response, configMap, result, inputMap);
        String processorName = (String)configMap.get("postprocessorname");
        Object dataPostProcessor = null;
        if (StringUtils.isNotBlank((String)processorName)) {
            LOGGER.debug((Object)("postprocessorname :" + processorName));
            try {
                dataPostProcessor = MiddlewareClassloaderFactory.getClassLoaderManager().getInstance(processorName);
                if (dataPostProcessor != null) {
                    Method[] methods = dataPostProcessor.getClass().getMethods();
                    Object object = null;
                    for (Method method : methods) {
                        OnException annos = method.getAnnotation(OnException.class);
                        if (annos == null) continue;
                        Class<?>[] classes = method.getParameterTypes();
                        Object[] parameterArray = new Object[classes.length];
                        Annotation[][] paramAnnotations = method.getParameterAnnotations();
                        if (paramAnnotations.length > 0) {
                            for (int j = 0; j < paramAnnotations.length; ++j) {
                                ContextParams name = AnnotationUtils.getParamNameForOnException(paramAnnotations[j]);
                                if (paramAnnotations[j].length > 0) {
                                    parameterArray[j] = name == null || ContextParams.DEFAULT.equals((Object)name) ? contextMap.get(classes[j]) : mapByParamName.get(name);
                                }
                                LOGGER.debug((Object)("OnException paramter " + j + " is of type " + name));
                            }
                            LOGGER.debug((Object)("Type parameters :: " + parameterArray));
                        }
                        object = method.invoke(dataPostProcessor, parameterArray);
                        break;
                    }
                    result = (Result)object;
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)e.getMessage(), e);
            }
        } else {
            LOGGER.debug((Object)"postprocessorname is not avaliable and post processing not required");
        }
        if (!(result == null || result.getAllParams().isEmpty() && result.getAllDatasets().isEmpty() && result.getAllRecords().isEmpty())) {
            request.setAttribute("ResultOnException", (Object)result);
        }
        return result;
    }

    private static Map<ContextParams, Object> prepareContextWithParamName(DataControllerRequest request, DataControllerResponse response, Map<String, Object> configMap, Result result, Map<String, Object> inputMap) {
        HashMap<ContextParams, Object> mapByParamName = new HashMap<ContextParams, Object>();
        mapByParamName.put(ContextParams.CONFIGMAP, configMap);
        mapByParamName.put(ContextParams.REQUEST, request);
        mapByParamName.put(ContextParams.INPUT, inputMap);
        mapByParamName.put(ContextParams.RESPONE, response);
        mapByParamName.put(ContextParams.RESULT, result);
        return mapByParamName;
    }

    private static Map<Class<?>, Object> prepareContext(DataControllerRequest request, DataControllerResponse response, Map<String, Object> inputMap, Result result, Exception exception) {
        HashMap contextMap = new HashMap();
        contextMap.put(DataControllerRequest.class, request);
        contextMap.put(DataControllerResponse.class, response);
        contextMap.put(Map.class, inputMap);
        contextMap.put(Result.class, result);
        contextMap.put(Exception.class, exception);
        return contextMap;
    }

    private static ContextParams getParamNameForOnException(Annotation[] annotations) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(KonyContext.class.getName())) continue;
            Method methodGetName = annotation.annotationType().getDeclaredMethod(KONYCONTEXT_PARAMETER_METHOD_NAME, new Class[0]);
            return (ContextParams)methodGetName.invoke((Object)annotation, new Object[0]);
        }
        return null;
    }

    private AnnotationUtils() {
    }
}

